/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome.install;

import com.android.tools.idea.welcome.install.InstallContext;
import com.android.tools.idea.welcome.install.InstallOperation;
import com.android.tools.idea.welcome.install.InstallationCancelledException;
import com.android.tools.idea.welcome.install.WizardException;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingAnsiEscapesAwareProcessHandler;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.ui.UIUtil;
import java.io.File;
import java.util.ArrayList;
import javax.swing.Icon;

public class CheckSdkOperation
extends InstallOperation<File, File> {
    public static final String ERROR_CANT_EXECUTE = "%1$s file is not a valid executable";
    public static final String ERROR_NO_TOOLS_DIR = "SDK tools directory is missing";
    public static final String MESSAGE_CANT_RUN_TOOL;
    public static final String ERROR_CANT_RUN_TOOL;
    public static final String URL_MISSING_LIBRARIES = "http://tools.android.com/tech-docs/linux-32-bit-libraries";
    public static final String LINK_MISSING_LIBRARIES = "Show Android SDK web page";
    public static final String TOOL_NAME;

    public CheckSdkOperation(InstallContext context) {
        super(context, 0.0);
    }

    private static Iterable<?> getUnableToRunMessage() {
        boolean isLinux64 = SystemInfo.isLinux && SystemInfo.is64Bit;
        String likelyReason = isLinux64 ? "One common reason for this is missing 32 bit compatibility libraries." : "One common reason for this failure is missing required libraries";
        String message = "Unable to run <strong>" + TOOL_NAME + "</strong> SDK tool.";
        ArrayList lines = Lists.newArrayList((Object[])new String[]{message, likelyReason, "Please fix the underlying issue and retry."});
        if (isLinux64) {
            String docHyperlink = "<a href=\"http://tools.android.com/tech-docs/linux-32-bit-libraries\">Show Android SDK web page</a>";
            lines.add(docHyperlink);
        }
        return lines;
    }

    private static boolean checkCanRunSdkTool(File executable) throws ExecutionException {
        GeneralCommandLine commandLine = new GeneralCommandLine(new String[]{executable.getAbsolutePath()});
        CapturingAnsiEscapesAwareProcessHandler handler = new CapturingAnsiEscapesAwareProcessHandler(commandLine);
        int exitCode = handler.runProcess().getExitCode();
        return exitCode == 1;
    }

    private static boolean checkExecutePermission(File executable) {
        if (executable.canExecute()) {
            return true;
        }
        return SystemInfo.isUnix && executable.setExecutable(true);
    }

    private static boolean retryPrompt() {
        int button = Messages.showOkCancelDialog((String)MESSAGE_CANT_RUN_TOOL, (String)"Android Studio", (String)"Retry", (String)"Cancel", (Icon)Messages.getErrorIcon());
        return button == 0;
    }

    private static boolean checkRuns(File executable) {
        try {
            while (!CheckSdkOperation.checkCanRunSdkTool(executable)) {
                final boolean[] shouldRetry = new boolean[]{false};
                UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        shouldRetry[0] = CheckSdkOperation.retryPrompt();
                    }
                });
                if (shouldRetry[0]) continue;
                return false;
            }
        }
        catch (ExecutionException e) {
            return false;
        }
        return true;
    }

    @Override
    protected File perform(ProgressIndicator indicator, File file) throws WizardException, InstallationCancelledException {
        File tool = new File(file, "tools" + File.separator + TOOL_NAME);
        if (!tool.isFile()) {
            throw new WizardException(ERROR_NO_TOOLS_DIR);
        }
        if (!CheckSdkOperation.checkExecutePermission(tool)) {
            throw new WizardException(String.format(ERROR_CANT_EXECUTE, tool.getAbsoluteFile()));
        }
        if (!CheckSdkOperation.checkRuns(tool)) {
            throw new WizardException(ERROR_CANT_RUN_TOOL);
        }
        return file;
    }

    @Override
    public void cleanup(File result) {
    }

    static {
        TOOL_NAME = "mksdcard" + (SystemInfo.isWindows ? ".exe" : "");
        ERROR_CANT_RUN_TOOL = "Unable to run " + TOOL_NAME + " SDK tool.";
        MESSAGE_CANT_RUN_TOOL = "<html><p>" + Joiner.on((String)"</p><p>").join(CheckSdkOperation.getUnableToRunMessage()) + "</p></html>";
    }
}

