/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome.install;

import com.android.ide.common.repository.SdkMavenRepository;
import com.android.sdklib.SdkManager;
import com.android.sdklib.devices.Storage;
import com.android.sdklib.repository.FullRevision;
import com.android.sdklib.repository.descriptors.IPkgDesc;
import com.android.sdklib.repository.descriptors.PkgDesc;
import com.android.sdklib.repository.descriptors.PkgType;
import com.android.tools.idea.sdk.remote.RemotePkgInfo;
import com.android.tools.idea.welcome.install.InstallContext;
import com.android.tools.idea.welcome.install.InstallableComponent;
import com.android.tools.idea.wizard.dynamic.ScopedStateStore;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;

public final class AndroidSdk
extends InstallableComponent {
    public static final long SIZE = 265L * Storage.Unit.MiB.getNumberOfBytes();

    public AndroidSdk(ScopedStateStore store) {
        super(store, "Android SDK", SIZE, "The collection of Android platform APIs, tools and utilities that enables you to debug, profile, and compile your apps.\n\nThe setup wizard will update your current Android SDK installation (if necessary) or install a new version.");
    }

    private static FullRevision getLatestCompatibleBuildToolsRevision(Multimap<PkgType, RemotePkgInfo> packages) {
        FullRevision revision = null;
        Collection tools = packages.get((Object)PkgType.PKG_BUILD_TOOLS);
        for (RemotePkgInfo tool : tools) {
            FullRevision fullRevision = tool.getPkgDesc().getFullRevision();
            if (fullRevision == null || fullRevision.isPreview() || revision != null && fullRevision.compareTo(revision) <= 0) continue;
            revision = fullRevision;
        }
        return revision;
    }

    @Override
    public Collection<IPkgDesc> getRequiredSdkPackages(Multimap<PkgType, RemotePkgInfo> remotePackages) {
        FullRevision revision;
        ArrayList result = Lists.newArrayList();
        result.add(PkgDesc.Builder.newTool((FullRevision)FullRevision.NOT_SPECIFIED, (FullRevision)FullRevision.NOT_SPECIFIED).create());
        result.add(PkgDesc.Builder.newPlatformTool((FullRevision)FullRevision.NOT_SPECIFIED).create());
        if (remotePackages != null && (revision = AndroidSdk.getLatestCompatibleBuildToolsRevision(remotePackages)) != null) {
            result.add(PkgDesc.Builder.newBuildTool((FullRevision)revision).create());
        }
        for (SdkMavenRepository repository : SdkMavenRepository.values()) {
            result.add(repository.getPackageDescription());
        }
        return result;
    }

    @Override
    public void configure(InstallContext installContext, File sdk) {
    }

    @Override
    protected boolean isOptionalForSdkLocation(SdkManager manager) {
        return false;
    }
}

