/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.properties.swing;

import com.android.tools.idea.ui.properties.core.StringProperty;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;

public final class TextProperty
extends StringProperty
implements DocumentListener,
PropertyChangeListener {
    private final JComponent myComponent;

    public TextProperty(JTextComponent textComponent) {
        this.myComponent = textComponent;
        textComponent.getDocument().addDocumentListener(this);
    }

    public TextProperty(AbstractButton button) {
        this.myComponent = button;
        button.addPropertyChangeListener("text", this);
    }

    public TextProperty(JLabel label) {
        this.myComponent = label;
        label.addPropertyChangeListener("text", this);
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.notifyInvalidated();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.notifyInvalidated();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.notifyInvalidated();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.notifyInvalidated();
    }

    @Override
    public String get() {
        if (this.myComponent instanceof JTextComponent) {
            return ((JTextComponent)this.myComponent).getText();
        }
        if (this.myComponent instanceof AbstractButton) {
            return ((AbstractButton)this.myComponent).getText();
        }
        if (this.myComponent instanceof JLabel) {
            return ((JLabel)this.myComponent).getText();
        }
        throw new IllegalStateException("Unexpected text component type: " + this.myComponent.getClass().getSimpleName());
    }

    @Override
    protected void setDirectly(String value) {
        if (this.myComponent instanceof JTextComponent) {
            ((JTextComponent)this.myComponent).setText(value);
        } else if (this.myComponent instanceof AbstractButton) {
            ((AbstractButton)this.myComponent).setText(value);
        } else if (this.myComponent instanceof JLabel) {
            ((JLabel)this.myComponent).setText(value);
        } else {
            throw new IllegalStateException("Unexpected text component type: " + this.myComponent.getClass().getSimpleName());
        }
    }
}

