/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.properties;

import com.android.tools.idea.ui.properties.InvalidationListener;
import com.android.tools.idea.ui.properties.Observable;
import com.google.common.collect.Lists;
import com.intellij.util.containers.UnsafeWeakList;
import java.util.List;

public abstract class AbstractObservable
implements Observable {
    private final List<InvalidationListener> myListeners = Lists.newArrayListWithCapacity((int)0);
    private final UnsafeWeakList<InvalidationListener> myWeakListeners = new UnsafeWeakList(0);
    private boolean myNotificationsEnabled = true;

    @Override
    public final void addListener(InvalidationListener listener) {
        this.myListeners.add(listener);
    }

    @Override
    public final void removeListener(InvalidationListener listener) {
        this.myListeners.remove(listener);
        this.myWeakListeners.remove((Object)listener);
    }

    @Override
    public final void addWeakListener(InvalidationListener listener) {
        this.myWeakListeners.add((Object)listener);
    }

    protected final void notifyInvalidated() {
        if (!this.myNotificationsEnabled) {
            return;
        }
        for (InvalidationListener listener : this.myListeners) {
            listener.onInvalidated(this);
        }
        for (InvalidationListener listener : this.myWeakListeners) {
            listener.onInvalidated(this);
        }
    }

    protected final void setNotificationsEnabled(boolean enabled) {
        this.myNotificationsEnabled = enabled;
    }
}

