/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.templates.recipe;

import com.android.tools.idea.templates.FreemarkerConfiguration;
import com.android.tools.idea.templates.StudioTemplateLoader;
import com.android.tools.idea.templates.Template;
import com.android.tools.idea.templates.recipe.DefaultRecipeExecutor;
import com.android.tools.idea.templates.recipe.FindReferencesRecipeExecutor;
import com.android.tools.idea.templates.recipe.RecipeExecutor;
import com.google.common.collect.Lists;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;

public class RenderingContext {
    private final Project myProject;
    private final String myTitle;
    private final Map<String, Object> myParamMap;
    private final File myOutputRoot;
    private final File myModuleRoot;
    private final boolean myGradleSync;
    private final boolean myFindOnlyReferences;
    private final StudioTemplateLoader myLoader;
    private final Configuration myFreemarker;
    private final Collection<File> mySourceFiles;
    private final Collection<File> myTargetFiles;
    private final Collection<File> myFilesToOpen;
    private final Collection<String> myDependencies;
    private final Collection<String> myWarnings;
    private final boolean myDryRun;
    private final boolean myShowErrors;

    private RenderingContext(Project project, File initialTemplatePath, String commandName, Map<String, Object> paramMap, File outputRoot, File moduleRoot, boolean gradleSyncIfNeeded, boolean findOnlyReferences, boolean dryRun, boolean showErrors, Collection<File> outSourceFiles, Collection<File> outTargetFiles, Collection<File> outOpenFiles, Collection<String> outDependencies) {
        this.myProject = RenderingContext.useDefaultProjectIfNeeded(project);
        this.myTitle = commandName;
        this.myParamMap = Template.createParameterMap(paramMap);
        this.myOutputRoot = outputRoot;
        this.myModuleRoot = moduleRoot;
        this.myGradleSync = gradleSyncIfNeeded;
        this.myFindOnlyReferences = findOnlyReferences;
        this.myDryRun = dryRun;
        this.myShowErrors = showErrors;
        this.myLoader = new StudioTemplateLoader(initialTemplatePath);
        this.myFreemarker = new FreemarkerConfiguration();
        this.myFreemarker.setTemplateLoader((TemplateLoader)this.myLoader);
        this.mySourceFiles = outSourceFiles != null ? outSourceFiles : Lists.newArrayList();
        this.myTargetFiles = outTargetFiles != null ? outTargetFiles : Lists.newArrayList();
        this.myFilesToOpen = outOpenFiles != null ? outOpenFiles : Lists.newArrayList();
        this.myDependencies = outDependencies != null ? outDependencies : Lists.newArrayList();
        this.myWarnings = Lists.newArrayList();
    }

    public Project getProject() {
        return this.myProject;
    }

    public String getCommandName() {
        return this.myTitle;
    }

    public Map<String, Object> getParamMap() {
        return this.myParamMap;
    }

    public File getOutputRoot() {
        return this.myOutputRoot;
    }

    public File getModuleRoot() {
        return this.myModuleRoot;
    }

    public boolean performGradleSync() {
        return this.myGradleSync;
    }

    public boolean showErrors() {
        return this.myShowErrors;
    }

    public boolean showWarnings() {
        return this.myShowErrors && this.myDryRun;
    }

    public StudioTemplateLoader getLoader() {
        return this.myLoader;
    }

    public Configuration getFreemarkerConfiguration() {
        return this.myFreemarker;
    }

    public Collection<File> getTargetFiles() {
        return this.myTargetFiles;
    }

    public Collection<File> getFilesToOpen() {
        return this.myFilesToOpen;
    }

    public Collection<String> getDependencies() {
        return this.myDependencies;
    }

    public Collection<File> getSourceFiles() {
        return this.mySourceFiles;
    }

    public Collection<String> getWarnings() {
        return this.myWarnings;
    }

    public RecipeExecutor getRecipeExecutor() {
        if (this.myFindOnlyReferences) {
            return new FindReferencesRecipeExecutor(this);
        }
        return new DefaultRecipeExecutor(this, this.myDryRun);
    }

    public boolean canCausePartialRendering() {
        return !this.myDryRun;
    }

    private static Project useDefaultProjectIfNeeded(Project project) {
        return project != null ? project : ProjectManagerEx.getInstanceEx().getDefaultProject();
    }

    public static final class Builder {
        private final File myInitialTemplatePath;
        private final Project myProject;
        private String myCommandName;
        private Map<String, Object> myParams;
        private File myOutputRoot;
        private File myModuleRoot;
        private boolean myGradleSync;
        private boolean myFindOnlyReferences;
        private boolean myDryRun;
        private boolean myShowErrors;
        private Collection<File> mySourceFiles;
        private Collection<File> myTargetFiles;
        private Collection<File> myOpenFiles;
        private Collection<String> myDependencies;

        private Builder(File initialTemplatePath, Project project) {
            this.myInitialTemplatePath = initialTemplatePath;
            this.myProject = project;
            this.myCommandName = "Instantiate Template";
            this.myParams = Collections.emptyMap();
            this.myModuleRoot = this.myOutputRoot = VfsUtilCore.virtualToIoFile((VirtualFile)project.getBaseDir());
            this.myGradleSync = true;
            this.myFindOnlyReferences = false;
            this.myDryRun = false;
            this.myShowErrors = false;
        }

        public static Builder newContext(Template template, Project project) {
            return new Builder(template.getRootPath(), project);
        }

        public static Builder newContext(File templateRootPath, Project project) {
            return new Builder(templateRootPath, project);
        }

        public Builder withCommandName(String commandName) {
            this.myCommandName = commandName;
            return this;
        }

        public Builder withModule(Module module) {
            VirtualFile[] roots = ModuleRootManager.getInstance((Module)module).getContentRoots();
            assert (roots.length > 0);
            this.myModuleRoot = VfsUtilCore.virtualToIoFile((VirtualFile)roots[0]);
            return this;
        }

        public Builder withOutputRoot(File outputRoot) {
            this.myOutputRoot = outputRoot;
            return this;
        }

        public Builder withModuleRoot(File moduleRoot) {
            this.myModuleRoot = moduleRoot;
            return this;
        }

        public Builder withParams(Map<String, Object> params) {
            this.myParams = params;
            return this;
        }

        public Builder withGradleSync(boolean gradleSync) {
            this.myGradleSync = gradleSync;
            return this;
        }

        public Builder withFindOnlyReferences(boolean findOnlyReferences) {
            this.myFindOnlyReferences = findOnlyReferences;
            return this;
        }

        public Builder withDryRun(boolean dryRun) {
            this.myDryRun = dryRun;
            return this;
        }

        public Builder withShowErrors(boolean showErrors) {
            this.myShowErrors = showErrors;
            return this;
        }

        public Builder intoSourceFiles(Collection<File> sourceFiles) {
            this.mySourceFiles = sourceFiles;
            return this;
        }

        public Builder intoTargetFiles(Collection<File> targetFiles) {
            this.myTargetFiles = targetFiles;
            return this;
        }

        public Builder intoOpenFiles(Collection<File> openFiles) {
            this.myOpenFiles = openFiles;
            return this;
        }

        public Builder intoDependencies(Collection<String> dependencies) {
            this.myDependencies = dependencies;
            return this;
        }

        public RenderingContext build() {
            if (this.myDryRun) {
                this.mySourceFiles = null;
                this.myTargetFiles = null;
                this.myOpenFiles = null;
                this.myDependencies = null;
            }
            return new RenderingContext(this.myProject, this.myInitialTemplatePath, this.myCommandName, this.myParams, this.myOutputRoot, this.myModuleRoot, this.myGradleSync, this.myFindOnlyReferences, this.myDryRun, this.myShowErrors, this.mySourceFiles, this.myTargetFiles, this.myOpenFiles, this.myDependencies);
        }
    }
}

