/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.templates.parse;

import com.android.utils.XmlUtils;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import org.xml.sax.Attributes;

public final class SaxUtils {
    public static File getPath(Attributes attributes, String name) {
        String value = attributes.getValue(name);
        if (value == null) {
            return null;
        }
        String unescapedString = XmlUtils.fromXmlAttributeValue((String)value);
        return new File(FileUtil.toSystemDependentName((String)unescapedString));
    }

    public static String attrOrDefault(Attributes attributes, String name, String defaultValue) {
        String value = attributes.getValue(name);
        return value != null ? value : defaultValue;
    }

    public static String requireAttr(String tag, Attributes attributes, String name) {
        String result = attributes.getValue(name);
        if (result == null) {
            throw new RuntimeException(String.format("Required attribute \"%1$s\" not found in element <%2$s %3$s>", name, tag, SaxUtils.attrsToString(attributes)));
        }
        return result;
    }

    private static String attrsToString(Attributes attributes) {
        StringBuilder builder = new StringBuilder();
        builder.append('[');
        for (int i = 0; i < attributes.getLength(); ++i) {
            builder.append(attributes.getQName(i));
            builder.append('=');
            builder.append(attributes.getValue(i));
            if (i >= attributes.getLength() - 1) continue;
            builder.append("; ");
        }
        builder.append(']');
        return builder.toString();
    }
}

