/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.templates;

import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.npw.ThemeHelper;
import com.google.common.collect.Maps;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectLocator;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import freemarker.template.TemplateMethodModelEx;
import freemarker.template.TemplateModelException;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.android.facet.AndroidFacet;

public class FmGetApplicationThemeMethod
implements TemplateMethodModelEx {
    private final Map<String, Object> myParamMap;

    public FmGetApplicationThemeMethod(Map<String, Object> paramMap) {
        this.myParamMap = paramMap;
    }

    public Object exec(List arguments) throws TemplateModelException {
        Module module = this.findModuleIfAny();
        if (module == null) {
            return null;
        }
        ThemeHelper helper = new ThemeHelper(module);
        AndroidFacet facet = AndroidFacet.getInstance(module);
        if (facet == null) {
            return null;
        }
        VirtualFile projectFile = module.getProject().getProjectFile();
        if (projectFile == null) {
            return null;
        }
        ConfigurationManager manager = facet.getConfigurationManager();
        Configuration configuration = manager.getConfiguration(projectFile);
        String themeName = helper.getAppThemeName();
        if (themeName == null) {
            return null;
        }
        HashMap map = Maps.newHashMap();
        map.put("name", themeName);
        map.put("isAppCompat", helper.isAppCompatTheme(themeName));
        Boolean hasActionBar = ThemeHelper.hasActionBar(configuration, themeName);
        FmGetApplicationThemeMethod.addDerivedTheme(map, themeName, "NoActionBar", hasActionBar == Boolean.FALSE, helper, configuration);
        FmGetApplicationThemeMethod.addDerivedTheme(map, themeName, "AppBarOverlay", false, helper, configuration);
        FmGetApplicationThemeMethod.addDerivedTheme(map, themeName, "PopupOverlay", false, helper, configuration);
        return map;
    }

    private static void addDerivedTheme(Map<String, Object> map, String themeName, String derivedThemeName, boolean useBaseThemeAsDerivedTheme, ThemeHelper helper, Configuration configuration) {
        String fullThemeName = useBaseThemeAsDerivedTheme ? themeName : themeName + "." + derivedThemeName;
        boolean exists = ThemeHelper.themeExists(configuration, fullThemeName);
        if (!exists && !helper.isLocalTheme(themeName)) {
            fullThemeName = derivedThemeName;
            exists = helper.isLocalTheme(derivedThemeName);
        }
        map.put("name" + derivedThemeName, fullThemeName);
        map.put("exists" + derivedThemeName, exists);
    }

    private Module findModuleIfAny() {
        Project project;
        VirtualFile file;
        String modulePath = (String)this.myParamMap.get("projectOut");
        if (modulePath != null && (file = LocalFileSystem.getInstance().findFileByIoFile(new File(modulePath.replace('/', File.separatorChar)))) != null && (project = ProjectLocator.getInstance().guessProjectForFile(file)) != null) {
            return ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)project);
        }
        return null;
    }
}

