/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.structure.services;

import com.android.tools.idea.structure.services.BuildSystemOperationsLookup;
import com.android.tools.idea.structure.services.DeveloperServiceMetadata;
import com.android.tools.idea.structure.services.ServiceCategory;
import com.android.tools.idea.structure.services.ServiceContext;
import com.android.tools.idea.structure.services.ServicePanelBuilder;
import com.android.tools.idea.templates.FreemarkerUtils;
import com.android.tools.idea.templates.TemplateUtils;
import com.android.tools.idea.templates.TypedVariable;
import com.android.tools.idea.templates.parse.SaxUtils;
import com.android.tools.idea.templates.recipe.Recipe;
import com.android.tools.idea.templates.recipe.RecipeExecutor;
import com.android.tools.idea.templates.recipe.RenderingContext;
import com.android.tools.idea.ui.properties.Observable;
import com.android.tools.idea.ui.properties.ObservableValue;
import com.android.tools.idea.ui.properties.collections.ObservableList;
import com.android.tools.idea.ui.properties.core.BoolProperty;
import com.android.tools.idea.ui.properties.core.IntProperty;
import com.android.tools.idea.ui.properties.core.StringProperty;
import com.android.tools.idea.ui.properties.expressions.bool.BooleanExpression;
import com.android.tools.idea.ui.properties.expressions.integer.IntExpression;
import com.android.tools.idea.ui.properties.expressions.string.StringExpression;
import com.android.tools.idea.ui.properties.swing.EnabledProperty;
import com.android.tools.idea.ui.properties.swing.SelectedIndexProperty;
import com.android.tools.idea.ui.properties.swing.SelectedProperty;
import com.android.tools.idea.ui.properties.swing.TextProperty;
import com.android.tools.idea.ui.properties.swing.VisibleProperty;
import com.google.common.base.CaseFormat;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.util.containers.Stack;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

final class ServiceXmlParser
extends DefaultHandler {
    private static final Logger LOG = Logger.getInstance(ServiceXmlParser.class);
    private static final int CURRENT_FORMAT = 1;
    private static final Pattern VAR_PATTERN = Pattern.compile("^\\$\\{(.+)\\}$");
    private static final Pattern ACTION_PATTERN = Pattern.compile("^\\$\\{(.+)\\(\\)\\}$");
    private final Module myModule;
    private final File myRootPath;
    private final ServiceContext myContext;
    private final Stack<String> myTagStack = new Stack();
    private ServicePanelBuilder myPanelBuilder;
    private ServiceCategory myServiceCategory;
    private DeveloperServiceMetadata myDeveloperServiceMetadata;
    private File myRecipeFile;

    public ServiceXmlParser(Module module, File rootPath, ServiceContext serviceContext) {
        this.myModule = module;
        this.myRootPath = rootPath;
        this.myContext = serviceContext;
        this.myPanelBuilder = new ServicePanelBuilder();
    }

    private static URI toUri(String urlString) {
        try {
            return new URI(urlString);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(String.format("Malformed link argument: %1$s", urlString), e);
        }
    }

    public Module getModule() {
        return this.myModule;
    }

    public ServiceContext getContext() {
        return this.myContext;
    }

    public DeveloperServiceMetadata getDeveloperServiceMetadata() {
        return this.myDeveloperServiceMetadata;
    }

    public ServiceCategory getServiceCategory() {
        return this.myServiceCategory;
    }

    public JPanel getServicePanel() {
        return this.myPanelBuilder.getPanel();
    }

    @Override
    public void startElement(String uri, String localName, String tagName, Attributes attributes) throws SAXException {
        this.myTagStack.push((Object)tagName);
        if (tagName.equals("service")) {
            this.parseServiceTag(attributes);
        } else if (tagName.equals("uiGrid")) {
            this.parseUiGridTag(attributes);
        } else if (tagName.equals("uiButton")) {
            this.parseUiButton(attributes);
        } else if (tagName.equals("uiCheckbox")) {
            this.parseUiCheckbox(attributes);
        } else if (tagName.equals("uiInput")) {
            this.parseUiInput(attributes);
        } else if (tagName.equals("uiLabel")) {
            this.parseUiLabel(attributes);
        } else if (tagName.equals("uiLink")) {
            this.parseUiLink(attributes);
        } else if (tagName.equals("uiPulldown")) {
            this.parseUiPulldown(attributes);
        } else {
            LOG.warn("WARNING: Unknown service directive " + tagName);
        }
    }

    @Override
    public void endElement(String uri, String localName, String tagName) throws SAXException {
        if (tagName.equals("service")) {
            this.closeServiceTag();
        } else if (tagName.equals("uiGrid")) {
            this.closeUiGridTag();
        }
        this.myTagStack.pop();
    }

    public void install() {
        ArrayList filesToOpen = Lists.newArrayList();
        this.analyzeRecipe(false, filesToOpen, null, null, null);
        TemplateUtils.openEditors(this.myModule.getProject(), filesToOpen, true);
    }

    private void analyzeRecipe(boolean findOnlyReferences, Collection<File> openFiles, Collection<String> dependencies, Collection<File> sourceFiles, Collection<File> targetFiles) {
        try {
            File moduleRoot = new File(this.myModule.getModuleFilePath()).getParentFile();
            RenderingContext context = RenderingContext.Builder.newContext(this.myRootPath, this.myModule.getProject()).withParams(this.myContext.toValueMap()).withOutputRoot(moduleRoot).withModuleRoot(moduleRoot).withFindOnlyReferences(findOnlyReferences).withGradleSync(false).intoOpenFiles(openFiles).intoDependencies(dependencies).intoSourceFiles(sourceFiles).intoTargetFiles(targetFiles).build();
            String xml = FreemarkerUtils.processFreemarkerTemplate(context, this.myRecipeFile, null);
            Recipe recipe = Recipe.parse(new StringReader(xml));
            RecipeExecutor recipeExecutor = context.getRecipeExecutor();
            recipe.execute(recipeExecutor);
        }
        catch (FreemarkerUtils.TemplateProcessingException e) {
            throw new RuntimeException(e);
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    private void parseServiceTag(Attributes attributes) {
        String format = this.requireAttr(attributes, "format");
        try {
            if (Integer.parseInt(format) > 1) {
                throw new RuntimeException(String.format("Definition found with format %1$s newer than newest known format %2$s", format, 1));
            }
        }
        catch (NumberFormatException e) {
            throw new RuntimeException(String.format("Non-numeric value passed to format attribute: %1$s", format));
        }
        String name = this.requireAttr(attributes, "name");
        String description = this.requireAttr(attributes, "description");
        String category = this.requireAttr(attributes, "category");
        File iconFile = new File(this.myRootPath, this.requireAttr(attributes, "icon"));
        String learnLink = attributes.getValue("learnMore");
        String apiLink = attributes.getValue("apiDocs");
        this.myRecipeFile = new File(this.myRootPath, this.requireAttr(attributes, "execute"));
        try {
            this.myServiceCategory = ServiceCategory.valueOf(CaseFormat.UPPER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, category));
        }
        catch (IllegalArgumentException e) {
            List validCategories = Lists.transform(Arrays.asList(ServiceCategory.values()), (Function)new Function<ServiceCategory, String>(){

                public String apply(ServiceCategory c) {
                    return c.getDisplayName();
                }
            });
            throw new RuntimeException(String.format("Invalid category \"%1$s\", should be one of [%2$s]", category, Joiner.on((char)',').join((Iterable)validCategories)));
        }
        ImageIcon icon = new ImageIcon(iconFile.getPath());
        this.myDeveloperServiceMetadata = new DeveloperServiceMetadata(name, description, icon);
        if (learnLink != null) {
            this.myDeveloperServiceMetadata.setLearnMoreLink(ServiceXmlParser.toUri(learnLink));
        }
        if (apiLink != null) {
            this.myDeveloperServiceMetadata.setApiLink(ServiceXmlParser.toUri(apiLink));
        }
    }

    private void closeServiceTag() {
        HashSet dependencies = Sets.newHashSet();
        ArrayList sourceFiles = Lists.newArrayList();
        ArrayList targetFiles = Lists.newArrayList();
        this.analyzeRecipe(true, null, dependencies, sourceFiles, targetFiles);
        for (String d : dependencies) {
            this.myDeveloperServiceMetadata.addDependency(d);
        }
        for (File f : sourceFiles) {
            if (!f.getName().equals("AndroidManifest.xml")) continue;
            this.parseManifestForPermissions(f);
        }
        for (File f : targetFiles) {
            this.myDeveloperServiceMetadata.addModifiedFile(f);
        }
        Project project = this.myModule.getProject();
        boolean allDependenciesFound = BuildSystemOperationsLookup.getBuildSystemOperations(project).containsAllDependencies(this.myModule, this.myDeveloperServiceMetadata);
        this.myContext.installed().set(allDependenciesFound);
        this.myContext.snapshot();
    }

    private void parseManifestForPermissions(File f) {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse(f, new DefaultHandler(){

                @Override
                public void startElement(String uri, String localName, String tagName, Attributes attributes) throws SAXException {
                    if (tagName.equals("uses-permission") || tagName.equals("uses-permission-sdk-23") || tagName.equals("uses-permission-sdk-m")) {
                        String permission = attributes.getValue("android:name");
                        permission = permission.replace("android.permission.", "");
                        ServiceXmlParser.this.myDeveloperServiceMetadata.addPermission(permission);
                    }
                }
            });
        }
        catch (Exception e) {
            LOG.warn("Failed to read permissions from AndroidManifest.xml", (Throwable)e);
        }
    }

    private void parseUiGridTag(Attributes attributes) {
        this.parseRowCol(attributes);
        String weights = this.requireAttr(attributes, "colDefinitions");
        JPanel grid = this.myPanelBuilder.startGrid(weights);
        this.bindTopLevelProperties(grid, attributes);
    }

    private void closeUiGridTag() {
        this.myPanelBuilder.endGrid();
    }

    private void parseUiButton(Attributes attributes) {
        String actionKey;
        this.parseRowCol(attributes);
        JButton button = this.myPanelBuilder.addButton();
        this.bindTopLevelProperties(button, attributes);
        String textKey = attributes.getValue("text");
        if (textKey != null) {
            TextProperty textProperty = new TextProperty(button);
            this.myPanelBuilder.getBindings().bind(textProperty, this.parseString(textKey));
        }
        if ((actionKey = attributes.getValue("action")) != null) {
            final Runnable action = this.parseAction(actionKey);
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    action.run();
                }
            });
        }
    }

    private void parseUiCheckbox(Attributes attributes) {
        String checkedKey;
        this.parseRowCol(attributes);
        JCheckBox checkbox = this.myPanelBuilder.addCheckbox();
        this.bindTopLevelProperties(checkbox, attributes);
        String textKey = attributes.getValue("text");
        if (textKey != null) {
            TextProperty textProperty = new TextProperty(checkbox);
            this.myPanelBuilder.getBindings().bind(textProperty, this.parseString(textKey));
        }
        if ((checkedKey = attributes.getValue("checked")) != null) {
            SelectedProperty selectedProperty = new SelectedProperty(checkbox);
            BoolProperty checkedValue = (BoolProperty)this.parseBool(checkedKey);
            this.myPanelBuilder.getBindings().bindTwoWay(selectedProperty, checkedValue);
        }
    }

    private void parseUiInput(Attributes attributes) {
        this.parseRowCol(attributes);
        JTextField field = this.myPanelBuilder.addField();
        this.bindTopLevelProperties(field, attributes);
        String textKey = attributes.getValue("text");
        if (textKey != null) {
            TextProperty textProperty = new TextProperty(field);
            StringProperty textValue = (StringProperty)this.parseString(textKey);
            this.myPanelBuilder.getBindings().bindTwoWay(textProperty, textValue);
        }
    }

    private void parseUiLabel(Attributes attributes) {
        this.parseRowCol(attributes);
        JLabel label = this.myPanelBuilder.addLabel();
        this.bindTopLevelProperties(label, attributes);
        String textKey = attributes.getValue("text");
        if (textKey != null) {
            TextProperty textProperty = new TextProperty(label);
            this.myPanelBuilder.getBindings().bind(textProperty, this.parseString(textKey));
        }
    }

    private void parseUiLink(Attributes attributes) {
        this.parseRowCol(attributes);
        HyperlinkLabel link = this.myPanelBuilder.addLink(this.requireAttr(attributes, "text"), ServiceXmlParser.toUri(this.requireAttr(attributes, "url")));
        this.bindTopLevelProperties((JComponent)link, attributes);
    }

    private void parseUiPulldown(Attributes attributes) {
        this.parseRowCol(attributes);
        String listKey = this.requireAttr(attributes, "list");
        ObservableList<String> backingList = this.getList(listKey);
        JComboBox comboBox = this.myPanelBuilder.addComboBox(backingList);
        this.bindTopLevelProperties(comboBox, attributes);
        String indexKey = attributes.getValue("index");
        if (indexKey != null) {
            SelectedIndexProperty indexProperty = new SelectedIndexProperty(comboBox);
            IntProperty indexValue = (IntProperty)this.parseInt(indexKey);
            this.myPanelBuilder.getBindings().bindTwoWay(indexProperty, indexValue);
        }
    }

    private void parseRowCol(Attributes attributes) {
        String col;
        String row = attributes.getValue("row");
        if (row != null) {
            this.myPanelBuilder.setRow(Integer.parseInt(row));
        }
        if ((col = attributes.getValue("col")) != null) {
            this.myPanelBuilder.setCol(Integer.parseInt(col));
        }
    }

    private void bindTopLevelProperties(JComponent component, Attributes attributes) {
        String enabledKey;
        String visibleKey = attributes.getValue("visible");
        if (visibleKey != null) {
            VisibleProperty visibleProperty = new VisibleProperty(component);
            this.myPanelBuilder.getBindings().bind(visibleProperty, this.parseBool(visibleKey));
        }
        if ((enabledKey = attributes.getValue("enabled")) != null) {
            EnabledProperty enabledProperty = new EnabledProperty(component);
            this.myPanelBuilder.getBindings().bind(enabledProperty, this.parseBool(enabledKey));
        }
    }

    private Runnable parseAction(String value) {
        Matcher matcher = ACTION_PATTERN.matcher(value);
        if (matcher.find()) {
            String varName = matcher.group(1);
            return this.myContext.getAction(varName);
        }
        throw new RuntimeException("Invalid action value (did you forget ${...()}): " + value);
    }

    private ObservableValue<Boolean> parseBool(String value) {
        Matcher matcher = VAR_PATTERN.matcher(value);
        if (matcher.find()) {
            return (ObservableValue)this.myContext.getValue(matcher.group(1));
        }
        final Boolean boolValue = (Boolean)TypedVariable.parse(TypedVariable.Type.BOOLEAN, value);
        if (boolValue == null) {
            throw new RuntimeException("Invalid bool value (did you forget ${...}): " + value);
        }
        return new BooleanExpression(new Observable[0]){

            @Override
            public Boolean get() {
                return boolValue;
            }
        };
    }

    private ObservableValue<String> parseString(final String value) {
        Matcher matcher = VAR_PATTERN.matcher(value);
        if (matcher.find()) {
            return (ObservableValue)this.myContext.getValue(matcher.group(1));
        }
        return new StringExpression(new Observable[0]){

            @Override
            public String get() {
                return value;
            }
        };
    }

    private ObservableValue<Integer> parseInt(String value) {
        Matcher matcher = VAR_PATTERN.matcher(value);
        if (matcher.find()) {
            return (ObservableValue)this.myContext.getValue(matcher.group(1));
        }
        final Integer intValue = (Integer)TypedVariable.parse(TypedVariable.Type.INTEGER, value);
        if (intValue == null) {
            throw new RuntimeException("Invalid integer value (did you forget ${...}): " + value);
        }
        return new IntExpression(new Observable[0]){

            @Override
            public Integer get() {
                return intValue;
            }
        };
    }

    private <E> ObservableList<E> getList(String value) {
        Matcher matcher = VAR_PATTERN.matcher(value);
        if (matcher.find()) {
            return (ObservableList)this.myContext.getValue(matcher.group(1));
        }
        throw new RuntimeException("Invalid list value (did you forget ${...}): " + value);
    }

    private String requireAttr(Attributes attributes, String attrFormat) {
        return SaxUtils.requireAttr((String)this.myTagStack.peek(), attributes, attrFormat);
    }

    private static final class Schema {
        private Schema() {
        }

        public static final class UiPulldown
        extends UiTag {
            public static final String TAG = "uiPulldown";
            public static final String ATTR_LIST = "list";
            public static final String ATTR_INDEX = "index";
        }

        public static final class UiLink
        extends UiTag {
            public static final String TAG = "uiLink";
            public static final String ATTR_TEXT = "text";
            public static final String ATTR_URL = "url";
        }

        public static final class UiLabel
        extends UiTag {
            public static final String TAG = "uiLabel";
            public static final String ATTR_TEXT = "text";
        }

        public static final class UiInput
        extends UiTag {
            public static final String TAG = "uiInput";
            public static final String ATTR_TEXT = "text";
        }

        public static final class UiCheckbox
        extends UiTag {
            public static final String TAG = "uiCheckbox";
            public static final String ATTR_TEXT = "text";
            public static final String ATTR_CHECKED = "checked";
        }

        public static final class UiButton
        extends UiTag {
            public static final String TAG = "uiButton";
            public static final String ATTR_TEXT = "text";
            public static final String ATTR_ACTION = "action";
        }

        public static final class UiGrid
        extends UiTag {
            public static final String TAG = "uiGrid";
            public static final String ATTR_COL_DEFINITIONS = "colDefinitions";
        }

        public static abstract class UiTag {
            public static final String ATTR_COL = "col";
            public static final String ATTR_ROW = "row";
            public static final String ATTR_ENABLED = "enabled";
            public static final String ATTR_VISIBLE = "visible";
        }

        public static final class Service {
            public static final String TAG = "service";
            public static final String ATTR_API_DOCS = "apiDocs";
            public static final String ATTR_CATEGORY = "category";
            public static final String ATTR_DESCRIPTION = "description";
            public static final String ATTR_EXECUTE = "execute";
            public static final String ATTR_FORMAT = "format";
            public static final String ATTR_ICON = "icon";
            public static final String ATTR_LEARN_MORE = "learnMore";
            public static final String ATTR_MIN_API = "minApi";
            public static final String ATTR_NAME = "name";
        }
    }
}

