/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.structure.services;

import com.android.tools.idea.model.ManifestInfo;
import com.android.tools.idea.structure.services.BuildSystemOperationsLookup;
import com.android.tools.idea.structure.services.DeveloperService;
import com.android.tools.idea.structure.services.DeveloperServiceBuildSystemOperations;
import com.android.tools.idea.structure.services.ServiceContext;
import com.android.tools.idea.structure.services.ServiceXmlParser;
import com.android.tools.idea.ui.properties.core.StringValueProperty;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import com.google.common.io.Resources;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.concurrent.Callable;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.jetbrains.android.facet.AndroidFacet;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class DeveloperServiceCreator {
    private static final String SERVICE_XML = "service.xml";
    private final File myRootPath;

    public DeveloperServiceCreator() {
        try {
            this.myRootPath = new File(FileUtil.generateRandomTemporaryPath(), this.getResourceRoot());
            this.myRootPath.deleteOnExit();
            for (String name : this.getResources()) {
                assert (!name.contains("..")) : "Initializer resource can't specify relative path";
                File file = new File(this.myRootPath, name);
                Files.createParentDirs((File)file);
                assert (file.createNewFile());
                String fullName = String.format("%1$s/%2$s", this.getResourceRoot(), name);
                URL resource = this.getClass().getResource(fullName);
                if (resource == null) {
                    throw new FileNotFoundException(String.format("Could not find service file %1$s", fullName));
                }
                Resources.asByteSource((URL)resource).copyTo(Files.asByteSink((File)file, (FileWriteMode[])new FileWriteMode[0]));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final DeveloperService createService(Module module) {
        if (AndroidFacet.getInstance(module) == null) {
            throw new IllegalArgumentException(String.format("Developer service cannot be associated with non-Android module %s", module.getName()));
        }
        ServiceContext context = DeveloperServiceCreator.createContext(module);
        this.initializeContext(context);
        final ServiceXmlParser serviceParser = new ServiceXmlParser(module, this.myRootPath, context);
        try {
            final FileInputStream serviceXml = new FileInputStream(new File(this.myRootPath, SERVICE_XML));
            try {
                WriteCommandAction.runWriteCommandAction((Project)module.getProject(), (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        try {
                            SAXParserFactory.newInstance().newSAXParser().parse(serviceXml, (DefaultHandler)serviceParser);
                        }
                        catch (ParserConfigurationException e) {
                            throw new RuntimeException(e);
                        }
                        catch (SAXException e) {
                            throw new RuntimeException(e);
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                });
            }
            finally {
                ((InputStream)serviceXml).close();
            }
        }
        catch (Exception e) {
            Logger.getInstance(this.getClass()).warn(String.format("Skipping over invalid service in module %1$s: %2$s", module.getName(), e.getMessage()));
            return null;
        }
        return new DeveloperService(serviceParser);
    }

    private static ServiceContext createContext(Module module) {
        String buildSystemId = BuildSystemOperationsLookup.getBuildSystemOperations(module.getProject()).getBuildSystemId();
        ServiceContext context = new ServiceContext(buildSystemId);
        String packageName = ManifestInfo.get(module, false).getPackage();
        if (packageName != null) {
            context.putValue("packageName", new StringValueProperty(packageName));
        }
        return context;
    }

    protected static <T> void runInBackground(final Callable<T> backgroundAction, final Dispatchable<T> dispatchAfter) {
        Application application = ApplicationManager.getApplication();
        application.executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                try {
                    Object result = backgroundAction.call();
                    if (result != null && dispatchAfter != null) {
                        dispatchAfter.dispatch(result);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    protected static void browse(String url) {
        BrowserUtil.browse((String)url);
    }

    protected static String getHighestVersion(String groupId, String artifactId, ServiceContext serviceContext) {
        DeveloperServiceBuildSystemOperations operations = BuildSystemOperationsLookup.getBuildSystemOperations(serviceContext.getBuildSystemId());
        return operations.getHighestVersion(groupId, artifactId);
    }

    protected abstract String getResourceRoot();

    protected abstract String[] getResources();

    protected void initializeContext(ServiceContext serviceContext) {
    }

    protected static interface Dispatchable<T> {
        public void dispatch(T var1);
    }
}

