/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.structure.services;

import com.android.tools.idea.stats.UsageTracker;
import com.android.tools.idea.structure.services.BuildSystemOperationsLookup;
import com.android.tools.idea.structure.services.DeveloperServiceMetadata;
import com.android.tools.idea.structure.services.ServiceCategory;
import com.android.tools.idea.structure.services.ServiceContext;
import com.android.tools.idea.structure.services.ServiceXmlParser;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import javax.swing.JPanel;

public final class DeveloperService {
    private final ServiceXmlParser myServiceParser;

    public DeveloperService(ServiceXmlParser serviceParser) {
        this.myServiceParser = serviceParser;
    }

    public Module getModule() {
        return this.myServiceParser.getModule();
    }

    public ServiceCategory getCategory() {
        return this.myServiceParser.getServiceCategory();
    }

    public DeveloperServiceMetadata getMetadata() {
        return this.myServiceParser.getDeveloperServiceMetadata();
    }

    public ServiceContext getContext() {
        return this.myServiceParser.getContext();
    }

    public JPanel getPanel() {
        return this.myServiceParser.getServicePanel();
    }

    public void install() {
        Project project = this.myServiceParser.getModule().getProject();
        new WriteCommandAction.Simple(project, "Install " + this.getMetadata().getName(), new PsiFile[0]){

            protected void run() throws Throwable {
                DeveloperService.this.myServiceParser.install();
            }
        }.execute();
        this.getContext().snapshot();
        this.trackEvent("installed");
    }

    public void uninstall() {
        if (!this.getContext().installed().get().booleanValue()) {
            return;
        }
        Module module = this.getModule();
        BuildSystemOperationsLookup.getBuildSystemOperations(module.getProject()).removeDependencies(module, this.getMetadata());
        this.trackEvent("removed");
    }

    private void trackEvent(String event) {
        UsageTracker.getInstance().trackEvent("devServices", event, this.getMetadata().getName(), null);
    }

    void updateInstalledState() {
        Module module = this.getModule();
        boolean isInstalled = BuildSystemOperationsLookup.getBuildSystemOperations(module.getProject()).isServiceInstalled(module, this.getMetadata());
        this.getContext().installed().set(isInstalled);
    }
}

