/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk;

import com.android.sdklib.SdkManager;
import com.android.sdklib.repository.FullRevision;
import com.android.sdklib.repository.MajorRevision;
import com.android.sdklib.repository.descriptors.IPkgDesc;
import com.android.sdklib.repository.descriptors.PkgType;
import com.android.sdklib.repository.local.LocalPkgInfo;
import com.android.sdklib.repository.local.LocalSdk;
import com.android.tools.idea.rendering.LogWrapper;
import com.android.utils.ILogger;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;

public class SdkMerger {
    private static final Logger LOG = Logger.getInstance(SdkMerger.class);

    public static void mergeSdks(File srcDir, File destDir, ProgressIndicator indicator) {
        Collection<MergeablePackage> packages = SdkMerger.compareSdks(srcDir, destDir);
        int numPackages = packages.size();
        int i = 0;
        for (MergeablePackage pkg : packages) {
            if (indicator != null) {
                if (indicator.isCanceled()) {
                    return;
                }
                indicator.setFraction((double)i++ / (double)numPackages);
                indicator.setText(String.format("Copying SDK package %1s", pkg.srcPkg.getDesc().getInstallId()));
            }
            if (pkg.destPkg != null) {
                File destPkgDir = pkg.destPkg.getLocalDir();
                try {
                    FileUtil.delete((File)destPkgDir);
                }
                catch (RuntimeException e) {
                    LOG.warn("Failed to delete destination directory " + destPkgDir.getPath(), (Throwable)e);
                }
            }
            try {
                FileUtil.copyDir((File)pkg.srcPkg.getLocalDir(), (File)pkg.srcPkg.getDesc().getCanonicalInstallFolder(pkg.destLocation));
            }
            catch (IOException e) {
                LOG.error("Unable to copy package " + pkg.srcPkg.getDesc().getInstallId(), (Throwable)e);
            }
        }
        if (indicator != null) {
            indicator.setFraction(1.0);
        }
    }

    public static boolean hasMergeableContent(File srcDir, File destDir) {
        return !SdkMerger.compareSdks(srcDir, destDir).isEmpty();
    }

    private static Collection<MergeablePackage> compareSdks(File srcDir, File destDir) {
        ArrayList results = Lists.newArrayList();
        LogWrapper logger = new LogWrapper(LOG);
        SdkManager destManager = SdkManager.createManager((String)destDir.getPath(), (ILogger)logger);
        SdkManager srcManager = SdkManager.createManager((String)srcDir.getPath(), (ILogger)logger);
        if (srcManager == null || destManager == null) {
            return results;
        }
        LocalSdk srcSdk = srcManager.getLocalSdk();
        LocalSdk destSdk = destManager.getLocalSdk();
        LocalPkgInfo[] srcPkgs = srcSdk.getPkgsInfos(EnumSet.allOf(PkgType.class));
        File destLocation = destSdk.getLocation();
        if (destLocation == null) {
            return results;
        }
        HashMap destPackages = Maps.newHashMap();
        for (LocalPkgInfo pkg : destSdk.getPkgsInfos(EnumSet.allOf(PkgType.class))) {
            destPackages.put(pkg.getDesc().getInstallId(), pkg);
        }
        for (LocalPkgInfo srcPkg : srcPkgs) {
            IPkgDesc srcPkgDesc = srcPkg.getDesc();
            LocalPkgInfo destPkg = (LocalPkgInfo)destPackages.get(srcPkg.getDesc().getInstallId());
            if (destPkg != null) {
                IPkgDesc destPkgDesc = destPkg.getDesc();
                FullRevision srcFullRevision = srcPkgDesc.getFullRevision();
                FullRevision destFullRevision = destPkgDesc.getFullRevision();
                MajorRevision srcMajorRevision = srcPkgDesc.getMajorRevision();
                MajorRevision destMajorRevision = destPkgDesc.getMajorRevision();
                if ((srcFullRevision == null || destFullRevision == null || srcFullRevision.compareTo(destFullRevision) <= 0) && (srcMajorRevision == null || destMajorRevision == null || srcMajorRevision.compareTo((FullRevision)destMajorRevision) <= 0)) continue;
                results.add(new MergeablePackage(srcPkg, destPkg, destLocation));
                continue;
            }
            results.add(new MergeablePackage(srcPkg, null, destLocation));
        }
        return results;
    }

    private static class MergeablePackage {
        private final LocalPkgInfo srcPkg;
        private final LocalPkgInfo destPkg;
        private final File destLocation;

        private MergeablePackage(LocalPkgInfo srcPkg, LocalPkgInfo destPkg, File destLocation) {
            this.srcPkg = srcPkg;
            this.destPkg = destPkg;
            this.destLocation = destLocation;
        }
    }
}

