/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.testing;

import com.intellij.execution.ui.ConfigurationModuleSelector;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;

public abstract class AndroidClassVisibilityCheckerBase
implements JavaCodeFragment.VisibilityChecker {
    private final ConfigurationModuleSelector myModuleSelector;

    public AndroidClassVisibilityCheckerBase(ConfigurationModuleSelector moduleSelector) {
        this.myModuleSelector = moduleSelector;
    }

    public JavaCodeFragment.VisibilityChecker.Visibility isDeclarationVisible(PsiElement declaration, PsiElement place) {
        VirtualFile vFile;
        if (!(declaration instanceof PsiClass)) {
            return JavaCodeFragment.VisibilityChecker.Visibility.NOT_VISIBLE;
        }
        Module module = this.myModuleSelector.getModule();
        if (module == null) {
            return JavaCodeFragment.VisibilityChecker.Visibility.NOT_VISIBLE;
        }
        PsiFile file = declaration.getContainingFile();
        VirtualFile virtualFile = vFile = file != null ? file.getVirtualFile() : null;
        if (vFile == null) {
            return JavaCodeFragment.VisibilityChecker.Visibility.NOT_VISIBLE;
        }
        return this.isVisible(module, (PsiClass)declaration) ? JavaCodeFragment.VisibilityChecker.Visibility.VISIBLE : JavaCodeFragment.VisibilityChecker.Visibility.NOT_VISIBLE;
    }

    protected abstract boolean isVisible(Module var1, PsiClass var2);
}

