/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.editor;

import com.android.tools.idea.run.editor.DeepLinkChooserDialog;
import com.android.tools.idea.run.editor.DeepLinkLaunch;
import com.android.tools.idea.run.editor.LaunchOptionConfigurable;
import com.android.tools.idea.run.editor.LaunchOptionConfigurableContext;
import com.intellij.execution.ExecutionBundle;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTextField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class DeepLinkConfigurable
implements LaunchOptionConfigurable<DeepLinkLaunch.State> {
    private JPanel myPanel;
    private ComponentWithBrowseButton<JBTextField> myDeepLinkField;

    public DeepLinkConfigurable(final Project project, final LaunchOptionConfigurableContext context) {
        this.$$$setupUI$$$();
        this.myDeepLinkField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!project.isInitialized()) {
                    return;
                }
                Module module = context.getModule();
                if (module == null) {
                    Messages.showErrorDialog((Project)project, (String)ExecutionBundle.message((String)"module.not.specified.error.text", (Object[])new Object[0]), (String)"Deep Link Launcher");
                    return;
                }
                DeepLinkChooserDialog dialog = new DeepLinkChooserDialog(project, module);
                dialog.setTitle("Select Deep Link");
                dialog.show();
                String deepLinkSelected = dialog.getSelectedDeepLink();
                if (deepLinkSelected != null && !deepLinkSelected.isEmpty()) {
                    ((JBTextField)DeepLinkConfigurable.this.myDeepLinkField.getChildComponent()).setText(deepLinkSelected);
                }
            }
        });
        ((JBTextField)this.myDeepLinkField.getChildComponent()).getEmptyText().setText("Specify deep link declared in the manifest");
    }

    private void createUIComponents() {
        this.myDeepLinkField = new ComponentWithBrowseButton((JComponent)new JBTextField(), null);
    }

    @Override
    public JComponent createComponent() {
        return this.myPanel;
    }

    @Override
    public void resetFrom(DeepLinkLaunch.State state) {
        ((JBTextField)this.myDeepLinkField.getChildComponent()).setText(StringUtil.notNullize((String)state.DEEP_LINK));
    }

    @Override
    public void applyTo(DeepLinkLaunch.State state) {
        state.DEEP_LINK = StringUtil.notNullize((String)((JBTextField)this.myDeepLinkField.getChildComponent()).getText());
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        this.createUIComponents();
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Deep Link:");
        jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(1, 0, 1, 2, 0, 2, 1, 6, null, null, null));
        ComponentWithBrowseButton<JBTextField> componentWithBrowseButton = this.myDeepLinkField;
        jPanel.add((Component)componentWithBrowseButton, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

