/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.editor;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.android.facet.AndroidFacet;

public class DeepLinkChooserDialog
extends DialogWrapper {
    private static final String TAG_INTENT_FILTER = "intent-filter";
    private static final String TAG_ACTION = "action";
    private static final String TAG_CATEGORY = "category";
    private static final String TAG_DATA = "data";
    private static final String ACTION_VIEW = "android.intent.action.VIEW";
    private static final String CATEGORY_DEFAULT = "android.intent.category.DEFAULT";
    private static final String CATEGORY_BROWSABLE = "android.intent.category.BROWSABLE";
    Project myProject;
    String mySelectedDeepLink = null;
    JBList myList;

    public DeepLinkChooserDialog(Project project, Module module) {
        super(project);
        XmlFile manifest;
        this.myProject = project;
        ArrayList deepLinks = Lists.newArrayList();
        if (module != null && module.getModuleFile() != null && module.getModuleFile().getParent() != null && (manifest = DeepLinkChooserDialog.getAndroidManifestPsi(module)) != null) {
            deepLinks.addAll(DeepLinkChooserDialog.getAllDeepLinks(manifest.getRootTag()));
        }
        this.myList = new JBList((Object[])deepLinks.toArray(new String[deepLinks.size()]));
        this.myList.setEmptyText("None found in AndroidManifest.xml");
        this.init();
    }

    public String getSelectedDeepLink() {
        return this.mySelectedDeepLink;
    }

    protected JComponent createCenterPanel() {
        JBScrollPane scrollPane = new JBScrollPane((Component)this.myList);
        this.myList.setSelectedIndex(0);
        new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent e) {
                int index = DeepLinkChooserDialog.this.myList.locationToIndex(e.getPoint());
                if (index != -1 && DeepLinkChooserDialog.this.myList.getModel().getElementAt(index) != null) {
                    DeepLinkChooserDialog.this.myList.setSelectedIndex(index);
                    DeepLinkChooserDialog.this.doOKAction();
                }
                return false;
            }
        }.installOn((Component)this.myList);
        return scrollPane;
    }

    protected void doOKAction() {
        this.mySelectedDeepLink = (String)this.myList.getSelectedValue();
        super.doOKAction();
    }

    private static XmlFile getAndroidManifestPsi(Module module) {
        PsiFile psiFile;
        VirtualFile manifest;
        File file;
        AndroidFacet facet = AndroidFacet.getInstance(module);
        if (facet != null && (file = facet.getMainSourceProvider().getManifestFile()) != null && (manifest = LocalFileSystem.getInstance().findFileByIoFile(file)) != null && (psiFile = PsiManager.getInstance((Project)module.getProject()).findFile(manifest)) instanceof XmlFile) {
            return (XmlFile)psiFile;
        }
        return null;
    }

    @VisibleForTesting
    static List<String> getAllDeepLinks(XmlTag root) {
        if (root == null) {
            return Lists.newArrayList();
        }
        List<XmlTag> intentFilters = DeepLinkChooserDialog.searchXmlTagsByName(root, TAG_INTENT_FILTER);
        ArrayList deepLinks = Lists.newArrayList();
        for (XmlTag intentFilter : intentFilters) {
            String deepLink = DeepLinkChooserDialog.getDeepLinkFromIntentFilter(intentFilter);
            if (deepLink == null) continue;
            deepLinks.add(deepLink);
        }
        return deepLinks;
    }

    private static List<XmlTag> searchXmlTagsByName(XmlTag root, final String tagName) {
        final ArrayList tags = Lists.newArrayList();
        root.accept((PsiElementVisitor)new XmlRecursiveElementVisitor(){

            public void visitXmlTag(XmlTag tag) {
                super.visitXmlTag(tag);
                if (tag.getName().equalsIgnoreCase(tagName)) {
                    tags.add(tag);
                }
            }
        });
        return tags;
    }

    private static String getDeepLinkFromIntentFilter(XmlTag intentFilter) {
        List<XmlTag> actions = DeepLinkChooserDialog.searchXmlTagsByName(intentFilter, TAG_ACTION);
        boolean hasActionView = false;
        for (XmlTag action : actions) {
            String name = action.getAttributeValue("name", "http://schemas.android.com/apk/res/android");
            if (name == null || !name.equals(ACTION_VIEW)) continue;
            hasActionView = true;
            break;
        }
        if (!hasActionView) {
            return null;
        }
        List<XmlTag> categories = DeepLinkChooserDialog.searchXmlTagsByName(intentFilter, TAG_CATEGORY);
        boolean hasDefaultCategory = false;
        boolean hasBrowsableCategory = false;
        for (XmlTag category : categories) {
            String name = category.getAttributeValue("name", "http://schemas.android.com/apk/res/android");
            if (name != null && name.equals(CATEGORY_DEFAULT)) {
                hasDefaultCategory = true;
                continue;
            }
            if (name == null || !name.equals(CATEGORY_BROWSABLE)) continue;
            hasBrowsableCategory = true;
        }
        if (!hasDefaultCategory || !hasBrowsableCategory) {
            return null;
        }
        List<XmlTag> datas = DeepLinkChooserDialog.searchXmlTagsByName(intentFilter, TAG_DATA);
        String scheme = null;
        String host = null;
        String pathPrefix = null;
        String path = null;
        for (XmlTag data : datas) {
            if (null != data.getAttributeValue("scheme", "http://schemas.android.com/apk/res/android")) {
                scheme = data.getAttributeValue("scheme", "http://schemas.android.com/apk/res/android");
            }
            if (null != data.getAttributeValue("host", "http://schemas.android.com/apk/res/android")) {
                host = data.getAttributeValue("host", "http://schemas.android.com/apk/res/android");
            }
            if (null != data.getAttributeValue("pathPrefix", "http://schemas.android.com/apk/res/android")) {
                pathPrefix = data.getAttributeValue("pathPrefix", "http://schemas.android.com/apk/res/android");
            }
            if (null == data.getAttributeValue("path", "http://schemas.android.com/apk/res/android")) continue;
            path = data.getAttributeValue("path", "http://schemas.android.com/apk/res/android");
        }
        if (scheme != null) {
            StringBuffer buf = new StringBuffer(scheme);
            buf.append("://");
            if (host != null) {
                buf.append(host);
                if (path != null) {
                    buf.append(path);
                } else if (pathPrefix != null) {
                    buf.append(pathPrefix);
                }
            }
            return buf.toString();
        }
        return null;
    }
}

