/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.activity;

import com.android.ddmlib.IDevice;
import com.android.tools.idea.model.ManifestInfo;
import com.android.tools.idea.run.activity.ActivityLocator;
import com.android.tools.idea.run.activity.ActivityLocatorUtils;
import com.intellij.execution.JavaExecutionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import java.util.List;
import org.jetbrains.android.dom.AndroidDomUtil;
import org.jetbrains.android.dom.manifest.Activity;
import org.jetbrains.android.dom.manifest.ActivityAlias;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidBundle;

public class SpecificActivityLocator
extends ActivityLocator {
    private final AndroidFacet myFacet;
    private final String myActivityName;

    public SpecificActivityLocator(AndroidFacet facet, String activityName) {
        this.myFacet = facet;
        this.myActivityName = activityName;
    }

    @Override
    public String getQualifiedActivityName(IDevice device) {
        assert (this.myActivityName != null);
        return this.myActivityName;
    }

    @Override
    public void validate() throws ActivityLocator.ActivityLocatorException {
        if (this.myActivityName == null || this.myActivityName.length() == 0) {
            throw new ActivityLocator.ActivityLocatorException(AndroidBundle.message("activity.class.not.specified.error", new Object[0]));
        }
        Module module = this.myFacet.getModule();
        Project project = module.getProject();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
        PsiClass activityClass = facade.findClass("android.app.Activity", ProjectScope.getAllScope((Project)project));
        if (activityClass == null) {
            throw new ActivityLocator.ActivityLocatorException(AndroidBundle.message("cant.find.activity.class.error", new Object[0]));
        }
        PsiClass c = JavaExecutionUtil.findMainClass((Project)project, (String)this.myActivityName, (GlobalSearchScope)GlobalSearchScope.projectScope((Project)project));
        if (c == null || !c.isInheritor(activityClass, true)) {
            ActivityAlias activityAlias = SpecificActivityLocator.findActivityAlias(this.myFacet, this.myActivityName);
            if (activityAlias == null) {
                throw new ActivityLocator.ActivityLocatorException(AndroidBundle.message("not.activity.subclass.error", this.myActivityName));
            }
            if (!ActivityLocatorUtils.containsLauncherIntent(activityAlias.getIntentFilters())) {
                throw new ActivityLocator.ActivityLocatorException(AndroidBundle.message("activity.not.launchable.error", "android.intent.action.MAIN"));
            }
            return;
        }
        if (SpecificActivityLocator.doesPackageContainMavenProperty(this.myFacet)) {
            return;
        }
        List<Activity> activities = ManifestInfo.get(module, false).getActivities();
        Activity activity = AndroidDomUtil.getActivityDomElementByClass(activities, c);
        if (activity != null) {
            return;
        }
        activities = ManifestInfo.get(module, true).getActivities();
        activity = AndroidDomUtil.getActivityDomElementByClass(activities, c);
        if (activity == null) {
            throw new ActivityLocator.ActivityLocatorException(AndroidBundle.message("activity.not.declared.in.manifest", c.getName()));
        }
        if (!ActivityLocatorUtils.shouldUseMergedManifest(this.myFacet)) {
            throw new ActivityLocator.ActivityLocatorException(AndroidBundle.message("activity.declared.but.manifest.merging.disabled", c.getName(), module.getName()));
        }
    }

    private static ActivityAlias findActivityAlias(AndroidFacet facet, final String qualifiedName) {
        final List<ActivityAlias> aliases = ManifestInfo.get(facet.getModule(), true).getActivityAliases();
        return (ActivityAlias)ApplicationManager.getApplication().runReadAction((Computable)new Computable<ActivityAlias>(){

            public ActivityAlias compute() {
                for (ActivityAlias alias : aliases) {
                    if (!qualifiedName.equals(ActivityLocatorUtils.getQualifiedName(alias))) continue;
                    return alias;
                }
                return null;
            }
        });
    }

    private static boolean doesPackageContainMavenProperty(AndroidFacet facet) {
        Manifest manifest = facet.getManifest();
        if (manifest == null) {
            return false;
        }
        String aPackage = manifest.getPackage().getStringValue();
        return aPackage != null && aPackage.contains("${");
    }
}

