/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.activity;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.ClientData;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.TimeoutException;
import com.android.tools.idea.run.AndroidApplicationLauncher;
import com.android.tools.idea.run.AndroidRunningState;
import com.android.tools.idea.run.activity.ActivityLocator;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.diagnostic.Logger;
import java.io.IOException;

public class AndroidActivityLauncher
extends AndroidApplicationLauncher {
    private static final Logger LOG = Logger.getInstance(AndroidActivityLauncher.class);
    private final ActivityLocator myActivityLocator;
    private final String myActivityExtraFlags;

    public AndroidActivityLauncher(ActivityLocator locator, String activityExtraFlags) {
        this.myActivityLocator = locator;
        this.myActivityExtraFlags = activityExtraFlags;
    }

    @Override
    public boolean isReadyForDebugging(ClientData data, ProcessHandler processHandler) {
        ClientData.DebuggerStatus status = data.getDebuggerConnectionStatus();
        switch (status) {
            case ERROR: {
                if (processHandler != null) {
                    processHandler.notifyTextAvailable("Debug port is busy\n", ProcessOutputTypes.STDOUT);
                }
                LOG.info("Debug port is busy");
                return false;
            }
            case ATTACHED: {
                if (processHandler != null) {
                    processHandler.notifyTextAvailable("Debugger already attached\n", ProcessOutputTypes.STDOUT);
                }
                LOG.info("Debugger already attached");
                return false;
            }
            case WAITING: {
                return true;
            }
        }
        String msg = "Client not ready yet.";
        if (processHandler != null) {
            processHandler.notifyTextAvailable(msg + "\n", ProcessOutputTypes.STDOUT);
        }
        LOG.info(msg);
        return false;
    }

    @Override
    public AndroidApplicationLauncher.LaunchResult launch(AndroidRunningState state, IDevice device) throws IOException, AdbCommandRejectedException, TimeoutException {
        String activityName;
        ProcessHandler processHandler = state.getProcessHandler();
        try {
            activityName = this.myActivityLocator.getQualifiedActivityName(device);
        }
        catch (ActivityLocator.ActivityLocatorException e) {
            processHandler.notifyTextAvailable("Could not identify launch activity: " + e.getMessage(), ProcessOutputTypes.STDOUT);
            return AndroidApplicationLauncher.LaunchResult.NOTHING_TO_DO;
        }
        String activityPath = AndroidActivityLauncher.getLauncherActivityPath(state.getPackageName(), activityName);
        if (state.isStopped()) {
            return AndroidApplicationLauncher.LaunchResult.STOP;
        }
        processHandler.notifyTextAvailable("Launching application: " + activityPath + ".\n", ProcessOutputTypes.STDOUT);
        String command = AndroidActivityLauncher.getStartActivityCommand(activityPath, this.getDebugFlags(state), this.myActivityExtraFlags);
        return this.executeCommand(command, state, device);
    }

    static String getStartActivityCommand(String activityPath, String debugFlags, String extraFlags) {
        return "am start " + debugFlags + " -n \"" + activityPath + "\" " + "-a android.intent.action.MAIN " + "-c android.intent.category.LAUNCHER" + (extraFlags.isEmpty() ? "" : " " + extraFlags);
    }

    static String getLauncherActivityPath(String packageName, String activityName) {
        return packageName + "/" + activityName.replace("$", "\\$");
    }
}

