/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.ddmlib.IDevice;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.run.ConnectedAndroidDevice;
import com.android.tools.idea.run.LaunchCompatibility;
import com.google.common.base.Predicate;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ThreeState;
import java.util.EnumSet;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.sdk.AndroidPlatform;

public abstract class TargetDeviceFilter
implements Predicate<IDevice> {
    public boolean apply(IDevice device) {
        return device != null && this.matchesDevice(device);
    }

    public abstract boolean matchesDevice(IDevice var1);

    public static class UsbDeviceFilter
    extends TargetDeviceFilter {
        @Override
        public boolean matchesDevice(IDevice device) {
            return !device.isEmulator();
        }
    }

    public static class EmulatorFilter
    extends TargetDeviceFilter {
        private final AndroidFacet myFacet;
        private final String myPreferredAvd;

        public EmulatorFilter(AndroidFacet facet, String preferredAvd) {
            this.myFacet = facet;
            this.myPreferredAvd = preferredAvd;
        }

        @Override
        public boolean matchesDevice(IDevice device) {
            if (!device.isEmulator()) {
                return false;
            }
            String avdName = device.getAvdName();
            if (this.myPreferredAvd != null) {
                return this.myPreferredAvd.equals(avdName);
            }
            AndroidPlatform androidPlatform = ((AndroidFacetConfiguration)this.myFacet.getConfiguration()).getAndroidPlatform();
            if (androidPlatform == null) {
                Logger.getInstance(EmulatorFilter.class).warn("Target Android platform not set for module: " + this.myFacet.getModule().getName());
                return false;
            }
            LaunchCompatibility compatibility = LaunchCompatibility.canRunOnDevice(AndroidModuleInfo.get(this.myFacet).getRuntimeMinSdkVersion(), androidPlatform.getTarget(), EnumSet.noneOf(IDevice.HardwareFeature.class), new ConnectedAndroidDevice(device, null), null);
            return compatibility.isCompatible() != ThreeState.NO;
        }
    }
}

