/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.tools.idea.run.ConsolePrinter;
import com.google.common.collect.Lists;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.util.Key;
import java.util.ArrayList;
import java.util.List;

public final class ProcessHandlerConsolePrinter
implements ConsolePrinter {
    private final Object myLock = new Object();
    private final List<Message> myStoredMessages = Lists.newArrayList();
    private ProcessHandler myProcessHandler;

    public ProcessHandlerConsolePrinter(ProcessHandler processHandler) {
        this.myProcessHandler = processHandler;
    }

    @Override
    public void stdout(String text) {
        this.print(text, ProcessOutputTypes.STDOUT);
    }

    @Override
    public void stderr(String text) {
        this.print(text, ProcessOutputTypes.STDERR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProcessHandler(ProcessHandler processHandler) {
        ArrayList storedMessages;
        Object object = this.myLock;
        synchronized (object) {
            this.myProcessHandler = processHandler;
            storedMessages = Lists.newArrayList(this.myStoredMessages);
            this.myStoredMessages.clear();
        }
        for (Message message : storedMessages) {
            this.print(message.text, message.outputType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void print(String text, Key outputType) {
        ProcessHandler processHandler;
        Object object = this.myLock;
        synchronized (object) {
            if (this.myProcessHandler == null) {
                this.myStoredMessages.add(new Message(text, outputType));
                return;
            }
            processHandler = this.myProcessHandler;
        }
        assert (!Thread.holdsLock(this.myLock));
        processHandler.notifyTextAvailable(text + "\n", outputType);
    }

    private static class Message {
        final String text;
        final Key outputType;

        Message(String text, Key outputType) {
            this.text = text;
            this.outputType = outputType;
        }
    }
}

