/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.build.OutputFile;
import com.android.builder.model.AndroidArtifact;
import com.android.builder.model.AndroidArtifactOutput;
import com.android.builder.model.BaseArtifact;
import com.android.builder.model.Variant;
import com.android.ddmlib.IDevice;
import com.android.ide.common.build.SplitOutputMatcher;
import com.android.tools.idea.gradle.AndroidGradleModel;
import com.android.tools.idea.gradle.structure.editors.AndroidProjectSettingsService;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.run.ApkInfo;
import com.android.tools.idea.run.ApkProvider;
import com.android.tools.idea.run.ApkProviderUtil;
import com.android.tools.idea.run.ApkProvisionException;
import com.android.tools.idea.run.ValidationError;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidBundle;

public class GradleApkProvider
implements ApkProvider {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.run.GradleApkProvider");
    private static final String DEFAULT_TEST_PACKAGE_SUFFIX = ".test";
    private final AndroidFacet myFacet;
    private final boolean myTest;

    public GradleApkProvider(AndroidFacet facet, boolean test) {
        this.myFacet = facet;
        this.myTest = test;
    }

    @Override
    public Collection<ApkInfo> getApks(IDevice device) throws ApkProvisionException {
        BaseArtifact testArtifactInfo;
        AndroidGradleModel androidModel = AndroidGradleModel.get(this.myFacet);
        assert (androidModel != null);
        Variant selectedVariant = androidModel.getSelectedVariant();
        ArrayList<ApkInfo> apkList = new ArrayList<ApkInfo>();
        if (!androidModel.getAndroidProject().isLibrary()) {
            File apk = GradleApkProvider.getApk(selectedVariant, device);
            apkList.add(new ApkInfo(apk, this.getPackageName()));
        }
        if (this.myTest && (testArtifactInfo = androidModel.findSelectedTestArtifactInSelectedVariant()) instanceof AndroidArtifact) {
            AndroidArtifactOutput output = GradleUtil.getOutput((AndroidArtifact)testArtifactInfo);
            File testApk = output.getMainOutputFile().getOutputFile();
            String testPackageName = this.getTestPackageName();
            assert (testPackageName != null);
            apkList.add(new ApkInfo(testApk, testPackageName));
        }
        return apkList;
    }

    @Override
    public String getPackageName() throws ApkProvisionException {
        return ApkProviderUtil.computePackageName(this.myFacet);
    }

    @Override
    public String getTestPackageName() throws ApkProvisionException {
        AndroidGradleModel androidModel = AndroidGradleModel.get(this.myFacet);
        assert (androidModel != null);
        Variant selectedVariant = androidModel.getSelectedVariant();
        String testPackageName = selectedVariant.getMergedFlavor().getTestApplicationId();
        return testPackageName != null ? testPackageName : this.getPackageName() + DEFAULT_TEST_PACKAGE_SUFFIX;
    }

    private static File getApk(Variant variant, IDevice device) throws ApkProvisionException {
        AndroidArtifact mainArtifact = variant.getMainArtifact();
        ArrayList outputs = Lists.newArrayList((Iterable)mainArtifact.getOutputs());
        if (outputs.isEmpty()) {
            throw new ApkProvisionException("No outputs for the main artifact of variant: " + variant.getDisplayName());
        }
        List abis = device.getAbis();
        int density = device.getDensity();
        Set variantAbiFilters = mainArtifact.getAbiFilters();
        List apkFiles = SplitOutputMatcher.computeBestOutput((List)outputs, (Collection)variantAbiFilters, (int)density, (Collection)abis);
        if (apkFiles.isEmpty()) {
            String message = AndroidBundle.message("deployment.failed.splitapk.nomatch", variant.getDisplayName(), outputs.size(), density, Joiner.on((String)", ").join((Iterable)abis));
            throw new ApkProvisionException(message);
        }
        return ((OutputFile)apkFiles.get(0)).getOutputFile();
    }

    @Override
    public List<ValidationError> validate() {
        AndroidGradleModel androidGradleModel = AndroidGradleModel.get(this.myFacet);
        assert (androidGradleModel != null);
        if (androidGradleModel.getMainArtifact().isSigned()) {
            return ImmutableList.of();
        }
        AndroidArtifactOutput output = GradleUtil.getOutput(androidGradleModel.getMainArtifact());
        String message = AndroidBundle.message("run.error.apk.not.signed", output.getMainOutputFile().getOutputFile().getName(), androidGradleModel.getSelectedVariant().getDisplayName());
        Runnable quickFix = new Runnable(){

            @Override
            public void run() {
                Module module = GradleApkProvider.this.myFacet.getModule();
                ProjectSettingsService service = ProjectSettingsService.getInstance((Project)module.getProject());
                if (service instanceof AndroidProjectSettingsService) {
                    ((AndroidProjectSettingsService)service).openSigningConfiguration(module);
                } else {
                    service.openModuleSettings(module);
                }
            }
        };
        return ImmutableList.of((Object)ValidationError.fatal(message, quickFix));
    }
}

