/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.ddmlib.IDevice;
import com.android.prefs.AndroidLocation;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.sdklib.internal.avd.AvdManager;
import com.android.tools.idea.run.ConsolePrinter;
import com.android.tools.idea.run.CreateAvdDialog;
import com.android.tools.idea.run.DeviceCount;
import com.android.tools.idea.run.DeviceReadyListener;
import com.android.tools.idea.run.DeviceSelectionUtils;
import com.android.tools.idea.run.DeviceTarget;
import com.android.tools.idea.run.TargetDeviceFilter;
import com.android.tools.idea.run.ValidationError;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.intellij.CommonBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.util.ui.UIUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.facet.AvdsNotSupportedException;
import org.jetbrains.android.sdk.AvdManagerLog;
import org.jetbrains.android.util.AndroidBundle;

public class EmulatorTargetChooser {
    private static final Logger LOG = Logger.getInstance(EmulatorTargetChooser.class);
    private final String myAvd;
    private final AndroidFacet myFacet;

    public EmulatorTargetChooser(AndroidFacet facet, String avd) {
        this.myFacet = facet;
        assert (avd == null || avd.length() > 0);
        this.myAvd = avd;
    }

    public DeviceTarget getTarget(ConsolePrinter printer, DeviceCount deviceCount, boolean debug) {
        String avd;
        TargetDeviceFilter.EmulatorFilter deviceFilter = new TargetDeviceFilter.EmulatorFilter(this.myFacet, this.myAvd);
        Collection<IDevice> runningDevices = DeviceSelectionUtils.chooseRunningDevice(this.myFacet, deviceFilter, deviceCount);
        if (runningDevices == null) {
            return null;
        }
        if (!runningDevices.isEmpty()) {
            return DeviceTarget.forDevices(runningDevices);
        }
        String string = avd = this.myAvd != null ? this.myAvd : this.chooseAvd();
        if (avd == null) {
            return null;
        }
        this.myFacet.launchEmulator(avd);
        Predicate<IDevice> avdNameFilter = new Predicate<IDevice>(){

            public boolean apply(IDevice device) {
                return device.isEmulator() && avd.equals(device.getAvdName());
            }
        };
        return DeviceTarget.forFuture(DeviceReadyListener.getReadyDevice(avdNameFilter, printer));
    }

    private String chooseAvd() {
        IAndroidTarget buildTarget = ((AndroidFacetConfiguration)this.myFacet.getConfiguration()).getAndroidTarget();
        assert (buildTarget != null);
        AvdInfo[] avds = this.myFacet.getValidCompatibleAvds();
        if (avds.length > 0) {
            return avds[0].getName();
        }
        final Project project = this.myFacet.getModule().getProject();
        AvdManager manager = null;
        try {
            manager = this.myFacet.getAvdManager(new AvdManagerLog(){

                @Override
                public void error(Throwable t, String errorFormat, Object ... args) {
                    super.error(t, errorFormat, args);
                    if (errorFormat != null) {
                        String msg = String.format(errorFormat, args);
                        LOG.error(msg);
                    }
                }
            });
        }
        catch (AvdsNotSupportedException e) {
            LOG.error((Throwable)e);
        }
        catch (AndroidLocation.AndroidLocationException e) {
            LOG.info((Throwable)e);
            UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                @Override
                public void run() {
                    Messages.showErrorDialog((Project)project, (String)e.getMessage(), (String)CommonBundle.getErrorTitle());
                }
            });
            return null;
        }
        final AvdManager finalManager = manager;
        assert (finalManager != null);
        return (String)UIUtil.invokeAndWaitIfNeeded((Computable)new Computable<String>(){

            public String compute() {
                AvdInfo createdAvd;
                CreateAvdDialog dialog = new CreateAvdDialog(project, EmulatorTargetChooser.this.myFacet, finalManager, true, true);
                dialog.show();
                if (dialog.getExitCode() == 0 && (createdAvd = dialog.getCreatedAvd()) != null) {
                    return createdAvd.getName();
                }
                return null;
            }
        });
    }

    public List<ValidationError> validate() {
        if (this.myAvd == null) {
            return ImmutableList.of();
        }
        AvdManager avdManager = this.myFacet.getAvdManagerSilently();
        if (avdManager == null) {
            return ImmutableList.of((Object)ValidationError.fatal(AndroidBundle.message("avd.cannot.be.loaded.error", new Object[0])));
        }
        AvdInfo avdInfo = avdManager.getAvd(this.myAvd, false);
        if (avdInfo == null) {
            return ImmutableList.of((Object)ValidationError.fatal(AndroidBundle.message("avd.not.found.error", this.myAvd)));
        }
        if (avdInfo.getStatus() != AvdInfo.AvdStatus.OK) {
            String message = avdInfo.getErrorMessage();
            message = AndroidBundle.message("avd.not.valid.error", this.myAvd) + (message != null ? ": " + message : "") + ". Try to repair it through AVD manager";
            return ImmutableList.of((Object)ValidationError.fatal(message));
        }
        return ImmutableList.of();
    }
}

