/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.ddmlib.IDevice;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Collection;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public final class DeviceTarget {
    private final Collection<ListenableFuture<IDevice>> myDeviceFutures;

    private DeviceTarget(Collection<ListenableFuture<IDevice>> deviceFutures) {
        this.myDeviceFutures = deviceFutures;
    }

    public static DeviceTarget forFuture(ListenableFuture<IDevice> deviceFuture) {
        return DeviceTarget.forFutures((Collection<ListenableFuture<IDevice>>)ImmutableList.of(deviceFuture));
    }

    public static DeviceTarget forFutures(Collection<ListenableFuture<IDevice>> deviceFutures) {
        return new DeviceTarget(deviceFutures);
    }

    public static DeviceTarget forDevices(Iterable<IDevice> devices) {
        ImmutableList.Builder futures = ImmutableList.builder();
        for (IDevice device : devices) {
            futures.add((Object)Futures.immediateFuture((Object)device));
        }
        return new DeviceTarget((Collection<ListenableFuture<IDevice>>)futures.build());
    }

    public Collection<ListenableFuture<IDevice>> getDeviceFutures() {
        return this.myDeviceFutures;
    }

    public Collection<IDevice> getDevicesIfReady() {
        for (ListenableFuture<IDevice> deviceFuture : this.myDeviceFutures) {
            if (deviceFuture.isDone() && !deviceFuture.isCancelled()) continue;
            return null;
        }
        try {
            return (Collection)Futures.get((Future)Futures.allAsList(this.myDeviceFutures), ExecutionException.class);
        }
        catch (ExecutionException e) {
            return null;
        }
    }
}

