/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import com.android.tools.idea.run.DeviceChooser;
import com.android.tools.idea.run.DeviceChooserDialog;
import com.android.tools.idea.run.DeviceCount;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.sdk.AndroidPlatform;

public class DeviceSelectionUtils {
    private static final Logger LOG = Logger.getInstance(DeviceSelectionUtils.class);
    private static final String ANDROID_TARGET_DEVICES_PROPERTY = "AndroidTargetDevices";

    public static Collection<IDevice> chooseRunningDevice(final AndroidFacet facet, final Predicate<IDevice> deviceFilter, final DeviceCount deviceCount) {
        List<IDevice> compatibleDevices = DeviceSelectionUtils.getAllCompatibleDevices(deviceFilter);
        if (compatibleDevices.size() == 0) {
            return ImmutableList.of();
        }
        if (compatibleDevices.size() == 1) {
            return compatibleDevices;
        }
        final AtomicReference devicesRef = new AtomicReference();
        ApplicationManager.getApplication().invokeAndWait(new Runnable(){

            @Override
            public void run() {
                devicesRef.set(DeviceSelectionUtils.chooseDevicesManually(facet, (Predicate<IDevice>)deviceFilter, deviceCount));
            }
        }, ModalityState.defaultModalityState());
        return ((IDevice[])devicesRef.get()).length > 0 ? ImmutableList.copyOf((Object[])((Object[])devicesRef.get())) : null;
    }

    public static List<IDevice> getAllCompatibleDevices(Predicate<IDevice> deviceFilter) {
        ArrayList<IDevice> compatibleDevices = new ArrayList<IDevice>();
        AndroidDebugBridge bridge = AndroidDebugBridge.getBridge();
        if (bridge != null) {
            IDevice[] devices;
            for (IDevice device : devices = bridge.getDevices()) {
                if (!deviceFilter.apply((Object)device)) continue;
                compatibleDevices.add(device);
            }
        }
        return compatibleDevices;
    }

    public static Collection<IDevice> getOnlineDevices(Collection<IDevice> devices) {
        if (devices == null) {
            return Collections.emptyList();
        }
        ArrayList online = Lists.newArrayListWithExpectedSize((int)devices.size());
        for (IDevice device : devices) {
            if (!device.isOnline()) continue;
            online.add(device);
        }
        return online;
    }

    private static IDevice[] chooseDevicesManually(AndroidFacet facet, Predicate<IDevice> filter, DeviceCount deviceCount) {
        Project project = facet.getModule().getProject();
        String value = PropertiesComponent.getInstance((Project)project).getValue(ANDROID_TARGET_DEVICES_PROPERTY);
        String[] selectedSerials = value != null ? DeviceSelectionUtils.deserialize(value) : null;
        AndroidPlatform platform = ((AndroidFacetConfiguration)facet.getConfiguration()).getAndroidPlatform();
        if (platform == null) {
            LOG.error("Android platform not set for module: " + facet.getModule().getName());
            return DeviceChooser.EMPTY_DEVICE_ARRAY;
        }
        DeviceChooserDialog chooser = new DeviceChooserDialog(facet, platform.getTarget(), deviceCount.isMultiple(), selectedSerials, filter);
        chooser.show();
        IDevice[] devices = chooser.getSelectedDevices();
        if (chooser.getExitCode() != 0 || devices.length == 0) {
            return DeviceChooser.EMPTY_DEVICE_ARRAY;
        }
        PropertiesComponent.getInstance((Project)project).setValue(ANDROID_TARGET_DEVICES_PROPERTY, DeviceSelectionUtils.serialize(devices));
        return devices;
    }

    public static String serialize(IDevice[] devices) {
        StringBuilder builder = new StringBuilder();
        int n = devices.length;
        for (int i = 0; i < n; ++i) {
            builder.append(devices[i].getSerialNumber());
            if (i >= n - 1) continue;
            builder.append(' ');
        }
        return builder.toString();
    }

    private static String[] deserialize(String s) {
        return s.split(" ");
    }
}

