/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import com.android.tools.idea.run.ConsolePrinter;
import com.google.common.base.Predicate;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;

public final class DeviceReadyListener
implements AndroidDebugBridge.IDeviceChangeListener,
Disposable {
    private final MergingUpdateQueue myQueue = new MergingUpdateQueue("ANDROID_DEVICE_STATE_UPDATE_QUEUE", 1000, true, null, (Disposable)this, null, false);
    private final ConsolePrinter myPrinter;
    private final Predicate<IDevice> myDeviceFilter;
    private final Callback myCallback;
    private final Object myFinishedLock = new Object();
    private boolean myFinished;

    public DeviceReadyListener(ConsolePrinter printer, Predicate<IDevice> deviceFilter, Callback callback) {
        this.myPrinter = printer;
        this.myDeviceFilter = deviceFilter;
        this.myCallback = callback;
    }

    public void dispose() {
    }

    public void deviceConnected(IDevice device) {
        if (device.getAvdName() == null || this.myDeviceFilter.apply((Object)device)) {
            this.myPrinter.stdout("Device connected: " + device.getSerialNumber());
            this.myQueue.queue((Update)new MyDeviceStateUpdate(device));
        }
    }

    public void deviceDisconnected(IDevice device) {
        if (this.myDeviceFilter.apply((Object)device)) {
            this.myPrinter.stdout("Device disconnected: " + device.getSerialNumber());
        }
    }

    public void deviceChanged(final IDevice device, int changeMask) {
        this.myQueue.queue(new Update(device.getSerialNumber()){

            public void run() {
                DeviceReadyListener.this.onDeviceChanged(device);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onDeviceChanged(IDevice device) {
        Object object = this.myFinishedLock;
        synchronized (object) {
            if (this.myFinished || !this.myDeviceFilter.apply((Object)device) || !device.isOnline()) {
                return;
            }
            if (!DeviceReadyListener.isReady(device)) {
                return;
            }
            this.myPrinter.stdout("Device is ready: " + device.getName());
            this.myFinished = true;
        }
        Disposer.dispose((Disposable)this.myQueue);
        this.myCallback.onDeviceReady(device);
    }

    private static boolean isReady(IDevice device) {
        if (!device.isOnline()) {
            return false;
        }
        return device.getClients().length >= 5 || device.getClient("android.process.acore") != null || device.getClient("com.google.android.wearable.app") != null;
    }

    public static ListenableFuture<IDevice> getReadyDevice(Predicate<IDevice> deviceFilter, ConsolePrinter logger) {
        final SettableFuture future = SettableFuture.create();
        Callback callback = new Callback(){

            @Override
            public void onDeviceReady(IDevice device) {
                future.set((Object)device);
            }
        };
        final DeviceReadyListener deviceReadyListener = new DeviceReadyListener(logger, deviceFilter, callback);
        Futures.addCallback((ListenableFuture)future, (FutureCallback)new FutureCallback<IDevice>(){

            public void onSuccess(IDevice result) {
                DeviceReadyListener.shutdown(deviceReadyListener);
            }

            public void onFailure(Throwable t) {
                DeviceReadyListener.shutdown(deviceReadyListener);
            }
        });
        AndroidDebugBridge.addDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)deviceReadyListener);
        return future;
    }

    private static void shutdown(DeviceReadyListener listener) {
        Disposer.dispose((Disposable)listener);
        AndroidDebugBridge.removeDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)listener);
    }

    private class MyDeviceStateUpdate
    extends Update {
        private final IDevice myDevice;

        public MyDeviceStateUpdate(IDevice device) {
            super((Object)device.getSerialNumber());
            this.myDevice = device;
        }

        public void run() {
            DeviceReadyListener.this.onDeviceChanged(this.myDevice);
            DeviceReadyListener.this.myQueue.queue((Update)new MyDeviceStateUpdate(this.myDevice));
        }
    }

    static interface Callback {
        public void onDeviceReady(IDevice var1);
    }
}

