/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.Client;
import com.android.ddmlib.ClientData;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.TimeoutException;
import com.android.tools.idea.ddms.DevicePanel;
import com.android.tools.idea.ddms.adb.AdbService;
import com.android.tools.idea.logcat.AndroidLogcatView;
import com.android.tools.idea.monitor.AndroidToolWindowFactory;
import com.android.tools.idea.run.AndroidApplicationLauncher;
import com.android.tools.idea.run.AndroidExecutionState;
import com.android.tools.idea.run.AndroidProcessText;
import com.android.tools.idea.run.AndroidRunConfigurationBase;
import com.android.tools.idea.run.AndroidRunningStateListener;
import com.android.tools.idea.run.ApkInfo;
import com.android.tools.idea.run.ApkInstaller;
import com.android.tools.idea.run.ApkProvider;
import com.android.tools.idea.run.ApkProvisionException;
import com.android.tools.idea.run.ConsolePrinter;
import com.android.tools.idea.run.DebugLauncher;
import com.android.tools.idea.run.DeviceTarget;
import com.android.tools.idea.run.InstalledApkCache;
import com.android.tools.idea.run.LaunchOptions;
import com.android.tools.idea.run.LaunchUtils;
import com.android.tools.idea.run.ProcessHandlerConsolePrinter;
import com.android.tools.idea.stats.UsageTracker;
import com.google.common.base.Charsets;
import com.google.common.hash.Hashing;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.Content;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.DefaultDebugProcessHandler;
import java.awt.Component;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JComponent;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidOutputReceiver;
import org.jetbrains.android.util.AndroidUtils;

public class AndroidRunningState
implements RunProfileState,
AndroidExecutionState {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.run.AndroidRunningState");
    public static final int WAITING_TIME_SECS = 20;
    public static final String DEVICE_COMMAND_PREFIX = "DEVICE SHELL COMMAND: ";
    private final ApkProvider myApkProvider;
    private final String myPackageName;
    private final AndroidFacet myFacet;
    private final AndroidApplicationLauncher myApplicationLauncher;
    private final ProcessHandlerConsolePrinter myPrinter;
    private final AndroidRunConfigurationBase myConfiguration;
    private final LaunchOptions myLaunchOptions;
    private final Object myDebugLock = new Object();
    private final DeviceTarget myDeviceTarget;
    private volatile DebugLauncher myDebugLauncher;
    private final ExecutionEnvironment myEnv;
    private final AtomicBoolean myStopped = new AtomicBoolean(false);
    private volatile ProcessHandler myProcessHandler;
    private final Object myLock = new Object();
    private volatile boolean myApplicationDeployed = false;
    private ConsoleView myConsole;
    private final List<AndroidRunningStateListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private static int ourInstallationCount = 0;

    public AndroidRunningState(ExecutionEnvironment environment, AndroidFacet facet, ApkProvider apkProvider, DeviceTarget deviceTarget, ProcessHandlerConsolePrinter printer, AndroidApplicationLauncher applicationLauncher, LaunchOptions launchOptions, AndroidRunConfigurationBase configuration) throws ExecutionException {
        this.myFacet = facet;
        this.myApkProvider = apkProvider;
        this.myDeviceTarget = deviceTarget;
        this.myPrinter = printer;
        this.myConfiguration = configuration;
        this.myEnv = environment;
        this.myApplicationLauncher = applicationLauncher;
        this.myLaunchOptions = launchOptions;
        try {
            this.myPackageName = this.myApkProvider.getPackageName();
        }
        catch (ApkProvisionException e) {
            throw new ExecutionException("Unable to determine package name", (Throwable)e);
        }
    }

    public DebugLauncher getDebugLauncher() {
        return this.myDebugLauncher;
    }

    public void setDebugLauncher(DebugLauncher debugLauncher) {
        this.myDebugLauncher = debugLauncher;
    }

    public boolean isDebugMode() {
        return this.myLaunchOptions.isDebug();
    }

    @Override
    public AndroidRunConfigurationBase getConfiguration() {
        return this.myConfiguration;
    }

    public ExecutionEnvironment getEnvironment() {
        return this.myEnv;
    }

    public boolean isStopped() {
        return this.myStopped.get();
    }

    public AtomicBoolean getStoppedRef() {
        return this.myStopped;
    }

    public Object getRunningLock() {
        return this.myLock;
    }

    public String getPackageName() {
        return this.myPackageName;
    }

    public String getTestPackageName() {
        try {
            return this.myApkProvider.getTestPackageName();
        }
        catch (ApkProvisionException e) {
            return null;
        }
    }

    public Module getModule() {
        return this.myFacet.getModule();
    }

    public AndroidFacet getFacet() {
        return this.myFacet;
    }

    @Override
    public Collection<IDevice> getDevices() {
        return this.myDeviceTarget.getDevicesIfReady();
    }

    @Override
    public ConsoleView getConsoleView() {
        return this.myConsole;
    }

    public ConsolePrinter getPrinter() {
        return this.myPrinter;
    }

    private void launchDebug(Client client) {
        this.myDebugLauncher.launchDebug(client);
        this.myDebugLauncher = null;
    }

    public void setConsole(ConsoleView console) {
        this.myConsole = console;
    }

    public ExecutionResult execute(final Executor executor, ProgramRunner runner) throws ExecutionException {
        this.myProcessHandler = new DefaultDebugProcessHandler();
        AndroidProcessText.attach(this.myProcessHandler);
        this.myConsole = this.myConfiguration.attachConsole(this, executor);
        this.myPrinter.setProcessHandler(this.myProcessHandler);
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                AndroidRunningState.this.start();
            }
        });
        this.getProcessHandler().addProcessListener((ProcessListener)new ProcessAdapter(){

            public void onTextAvailable(ProcessEvent event, Key outputType) {
                if (outputType.equals((Object)ProcessOutputTypes.STDERR)) {
                    UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            ToolWindowManager.getInstance((Project)AndroidRunningState.this.myFacet.getModule().getProject()).getToolWindow(executor.getToolWindowId()).activate(null, true, false);
                        }
                    });
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void processWillTerminate(ProcessEvent event, boolean willBeDestroyed) {
                for (ListenableFuture<IDevice> deviceFuture : AndroidRunningState.this.myDeviceTarget.getDeviceFutures()) {
                    deviceFuture.cancel(true);
                }
                AndroidRunningState.this.myStopped.set(true);
                Object object = AndroidRunningState.this.myLock;
                synchronized (object) {
                    AndroidRunningState.this.myLock.notifyAll();
                }
                AndroidRunningState.this.getProcessHandler().removeProcessListener((ProcessListener)this);
            }
        });
        return new DefaultExecutionResult((ExecutionConsole)this.myConsole, this.myProcessHandler);
    }

    void start() {
        final AtomicInteger startedCount = new AtomicInteger();
        for (ListenableFuture<IDevice> targetDevice : this.myDeviceTarget.getDeviceFutures()) {
            Futures.addCallback(targetDevice, (FutureCallback)new FutureCallback<IDevice>(){

                public void onSuccess(IDevice device) {
                    if (AndroidRunningState.this.myStopped.get() || device == null) {
                        return;
                    }
                    if (AndroidRunningState.this.isDebugMode()) {
                        final MyClientChangeListener listener = new MyClientChangeListener(device);
                        AndroidDebugBridge.addClientChangeListener((AndroidDebugBridge.IClientChangeListener)listener);
                        AndroidRunningState.this.getProcessHandler().addProcessListener((ProcessListener)new ProcessAdapter(){

                            public void processWillTerminate(ProcessEvent event, boolean willBeDestroyed) {
                                AndroidDebugBridge.removeClientChangeListener((AndroidDebugBridge.IClientChangeListener)listener);
                            }
                        });
                    }
                    if (AndroidRunningState.this.prepareAndStartApp(device)) {
                        if (startedCount.incrementAndGet() == AndroidRunningState.this.myDeviceTarget.getDeviceFutures().size() && !AndroidRunningState.this.isDebugMode()) {
                            AndroidRunningState.this.myStopped.set(true);
                            AndroidRunningState.this.getProcessHandler().destroyProcess();
                        }
                        AndroidRunningState.this.fireExecutionStarted(device);
                    } else {
                        AndroidRunningState.this.fireExecutionFailed();
                        AndroidRunningState.this.myStopped.set(true);
                        AndroidRunningState.this.getProcessHandler().destroyProcess();
                    }
                }

                public void onFailure(Throwable t) {
                    AndroidRunningState.this.myPrinter.stderr(t.getMessage());
                    AndroidRunningState.this.myStopped.set(true);
                    AndroidRunningState.this.getProcessHandler().destroyProcess();
                }
            });
        }
    }

    public synchronized void setProcessHandler(ProcessHandler processHandler) {
        this.myProcessHandler = processHandler;
        this.myPrinter.setProcessHandler(processHandler);
    }

    public synchronized ProcessHandler getProcessHandler() {
        return this.myProcessHandler;
    }

    private void fireExecutionFailed() {
        for (AndroidRunningStateListener listener : this.myListeners) {
            listener.executionFailed();
        }
    }

    private void fireExecutionStarted(IDevice device) {
        for (AndroidRunningStateListener listener : this.myListeners) {
            listener.executionStarted(device);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean prepareAndStartApp(IDevice device) {
        if (this.isDebugMode() && !LaunchUtils.canDebugAppOnDevice(this.myFacet, device)) {
            this.myPrinter.stderr(AndroidBundle.message("android.cannot.debug.noDebugPermissions", this.getPackageName(), device.getName()));
            return false;
        }
        if (this.myLaunchOptions.isClearLogcatBeforeStart()) {
            AndroidRunningState.clearLogcatAndConsole(this.getModule().getProject(), device);
        }
        this.myPrinter.stdout("Target device: " + device.getName());
        try {
            Client client;
            if (this.myLaunchOptions.isDeploy()) {
                if (!this.installApks(device)) {
                    return false;
                }
                AndroidRunningState.trackInstallation(device);
                this.myApplicationDeployed = true;
            }
            LaunchUtils.initiateDismissKeyguard(device);
            AndroidApplicationLauncher.LaunchResult launchResult = this.myApplicationLauncher.launch(this, device);
            if (launchResult == AndroidApplicationLauncher.LaunchResult.STOP) {
                return false;
            }
            if (launchResult == AndroidApplicationLauncher.LaunchResult.SUCCESS) {
                this.checkDdms();
            }
            String pkgName = this.getPackageName();
            Object object = this.myDebugLock;
            synchronized (object) {
                client = device.getClient(pkgName);
                if (this.myDebugLauncher != null) {
                    if (client != null && this.myApplicationLauncher.isReadyForDebugging(client.getClientData(), this.getProcessHandler())) {
                        this.launchDebug(client);
                    } else {
                        this.myPrinter.stdout("Waiting for process: " + pkgName);
                    }
                }
            }
            if (!this.isDebugMode() && this.myLaunchOptions.isOpenLogcatAutomatically()) {
                this.showLogcatConsole(device, client);
            }
            return true;
        }
        catch (TimeoutException e) {
            LOG.info((Throwable)e);
            this.myPrinter.stderr("Error: Connection to ADB failed with a timeout");
            return false;
        }
        catch (AdbCommandRejectedException e) {
            LOG.info((Throwable)e);
            this.myPrinter.stderr("Error: adb rejected command: " + (Object)((Object)e));
            return false;
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
            String message = e.getMessage();
            this.myPrinter.stderr("I/O Error" + (message != null ? ": " + message : ""));
            return false;
        }
    }

    private boolean installApks(IDevice device) {
        Collection<ApkInfo> apks;
        try {
            apks = this.myApkProvider.getApks(device);
        }
        catch (ApkProvisionException e) {
            this.myPrinter.stderr(e.getMessage());
            LOG.warn((Throwable)e);
            return false;
        }
        ApkInstaller installer = new ApkInstaller(this.myFacet, this.myLaunchOptions, (InstalledApkCache)ServiceManager.getService(InstalledApkCache.class), this.myPrinter);
        for (ApkInfo apk : apks) {
            if (!apk.getFile().exists()) {
                String message = "The APK file " + apk.getFile().getPath() + " does not exist on disk.";
                this.myPrinter.stderr(message);
                LOG.error(message);
                return false;
            }
            if (installer.uploadAndInstallApk(device, apk.getApplicationId(), apk.getFile(), this.myStopped)) continue;
            return false;
        }
        return true;
    }

    private static void trackInstallation(IDevice device) {
        if (!UsageTracker.getInstance().canTrack()) {
            return;
        }
        if ((ourInstallationCount = (ourInstallationCount + 1) % 10) != 0) {
            return;
        }
        UsageTracker.getInstance().trackEvent("deployment", "apkDeployed", null, null);
        UsageTracker.getInstance().trackEvent("deviceInfo", "ro.serialno.hashed", Hashing.md5().hashString((CharSequence)device.getSerialNumber(), Charsets.UTF_8).toString(), null);
        UsageTracker.getInstance().trackEvent("deviceInfo", "ro.build.tags", device.getProperty("ro.build.tags"), null);
        UsageTracker.getInstance().trackEvent("deviceInfo", "ro.build.type", device.getProperty("ro.build.type"), null);
        UsageTracker.getInstance().trackEvent("deviceInfo", "ro.build.version.release", device.getProperty("ro.build.version.release"), null);
        UsageTracker.getInstance().trackEvent("deviceInfo", "ro.build.version.sdk", device.getProperty("ro.build.version.sdk"), null);
        UsageTracker.getInstance().trackEvent("deviceInfo", "ro.product.manufacturer", device.getProperty("ro.product.manufacturer"), null);
        UsageTracker.getInstance().trackEvent("deviceInfo", "ro.product.model", device.getProperty("ro.product.model"), null);
        UsageTracker.getInstance().trackEvent("deviceInfo", "ro.product.cpu.abi", device.getProperty("ro.product.cpu.abi"), null);
    }

    private static void clearLogcatAndConsole(final Project project, final IDevice device) {
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                ToolWindow toolWindow = ToolWindowManager.getInstance((Project)project).getToolWindow(AndroidToolWindowFactory.TOOL_WINDOW_ID);
                if (toolWindow == null) {
                    return;
                }
                for (Content content : toolWindow.getContentManager().getContents()) {
                    AndroidLogcatView view = (AndroidLogcatView)content.getUserData(AndroidLogcatView.ANDROID_LOGCAT_VIEW_KEY);
                    if (view == null) continue;
                    view.clearLogcat(device);
                }
            }
        });
    }

    private void showLogcatConsole(final IDevice device, final Client client) {
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                final ToolWindow androidToolWindow = ToolWindowManager.getInstance((Project)AndroidRunningState.this.myEnv.getProject()).getToolWindow(AndroidToolWindowFactory.TOOL_WINDOW_ID);
                androidToolWindow.activate(new Runnable(){

                    @Override
                    public void run() {
                        int count = androidToolWindow.getContentManager().getContentCount();
                        for (int i = 0; i < count; ++i) {
                            DevicePanel devicePanel;
                            Content content = androidToolWindow.getContentManager().getContent(i);
                            DevicePanel devicePanel2 = devicePanel = content == null ? null : (DevicePanel)content.getUserData(AndroidToolWindowFactory.DEVICES_PANEL_KEY);
                            if (devicePanel == null) continue;
                            devicePanel.selectDevice(device);
                            devicePanel.selectClient(client);
                            break;
                        }
                    }
                }, false);
            }
        });
    }

    private boolean checkDdms() {
        AndroidDebugBridge bridge = AndroidDebugBridge.getBridge();
        if (this.isDebugMode() && bridge != null && AdbService.canDdmsBeCorrupted(bridge)) {
            JComponent component;
            this.myPrinter.stderr(AndroidBundle.message("ddms.corrupted.error", new Object[0]));
            JComponent jComponent = component = this.myConsole == null ? null : this.myConsole.getComponent();
            if (component != null) {
                final ExecutionEnvironment environment = (ExecutionEnvironment)LangDataKeys.EXECUTION_ENVIRONMENT.getData(DataManager.getInstance().getDataContext((Component)component));
                if (environment == null) {
                    return false;
                }
                this.myConsole.printHyperlink(AndroidBundle.message("restart.adb.fix.text", new Object[0]), new HyperlinkInfo(){

                    public void navigate(Project project) {
                        AdbService.getInstance().restartDdmlib(project);
                        ProcessHandler processHandler = AndroidRunningState.this.getProcessHandler();
                        if (!processHandler.isProcessTerminated()) {
                            processHandler.destroyProcess();
                        }
                        ExecutionUtil.restart((ExecutionEnvironment)environment);
                    }
                });
                this.myConsole.print("\n", ConsoleViewContentType.NORMAL_OUTPUT);
            }
            return false;
        }
        return true;
    }

    public void executeDeviceCommandAndWriteToConsole(IDevice device, String command, AndroidOutputReceiver receiver) throws IOException, TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException {
        this.myPrinter.stdout(DEVICE_COMMAND_PREFIX + command);
        AndroidUtils.executeCommandOnDevice(device, command, receiver, false);
    }

    public void addListener(AndroidRunningStateListener listener) {
        this.myListeners.add(listener);
    }

    private class MyClientChangeListener
    implements AndroidDebugBridge.IClientChangeListener {
        private final IDevice myDevice;

        MyClientChangeListener(IDevice device) {
            this.myDevice = device;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clientChanged(Client client, int changeMask) {
            Object object = AndroidRunningState.this.myDebugLock;
            synchronized (object) {
                ClientData data;
                if (AndroidRunningState.this.myDebugLauncher == null) {
                    return;
                }
                if (AndroidRunningState.this.myLaunchOptions.isDeploy() && !AndroidRunningState.this.myApplicationDeployed) {
                    return;
                }
                IDevice device = client.getDevice();
                if (this.myDevice.equals(device) && device.isOnline() && this.isToLaunchDebug(data = client.getClientData())) {
                    AndroidRunningState.this.launchDebug(client);
                }
            }
        }

        private boolean isToLaunchDebug(ClientData data) {
            if (AndroidRunningState.this.myApplicationLauncher.isReadyForDebugging(data, AndroidRunningState.this.getProcessHandler())) {
                return true;
            }
            String description = data.getClientDescription();
            if (description == null) {
                return false;
            }
            return description.equals(AndroidRunningState.this.getPackageName());
        }
    }
}

