/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.tools.idea.run.AndroidRunConfiguration;
import com.android.tools.idea.startup.AndroidStudioInitializer;
import com.intellij.compiler.options.CompileStepBeforeRun;
import com.intellij.execution.BeforeRunTask;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.ConfigurationTypeUtil;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import icons.AndroidIcons;
import javax.swing.Icon;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidBundle;

public class AndroidRunConfigurationType
implements ConfigurationType {
    private final ConfigurationFactory myFactory = new AndroidRunConfigurationFactory(this);

    public static AndroidRunConfigurationType getInstance() {
        return (AndroidRunConfigurationType)ConfigurationTypeUtil.findConfigurationType(AndroidRunConfigurationType.class);
    }

    public String getDisplayName() {
        return AndroidBundle.message("android.run.configuration.type.name", new Object[0]);
    }

    public String getConfigurationTypeDescription() {
        return AndroidBundle.message("android.run.configuration.type.description", new Object[0]);
    }

    public Icon getIcon() {
        return AndroidIcons.Android;
    }

    public String getId() {
        return "AndroidRunConfigurationType";
    }

    public ConfigurationFactory[] getConfigurationFactories() {
        return new ConfigurationFactory[]{this.myFactory};
    }

    public ConfigurationFactory getFactory() {
        return this.myFactory;
    }

    public static class AndroidRunConfigurationFactory
    extends ConfigurationFactory {
        protected AndroidRunConfigurationFactory(ConfigurationType type) {
            super(type);
        }

        public RunConfiguration createTemplateConfiguration(Project project) {
            return new AndroidRunConfiguration(project, this);
        }

        public boolean canConfigurationBeSingleton() {
            return false;
        }

        public boolean isApplicable(Project project) {
            return ProjectFacetManager.getInstance((Project)project).hasFacets(AndroidFacet.ID);
        }

        public void configureBeforeRunTaskDefaults(Key<? extends BeforeRunTask> providerID, BeforeRunTask task) {
            if (AndroidStudioInitializer.isAndroidStudio() && CompileStepBeforeRun.ID.equals(providerID)) {
                task.setEnabled(false);
            }
        }
    }
}

