/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering.multi;

import com.google.common.collect.Sets;
import java.util.Collection;

public enum RenderPreviewMode {
    DEFAULT,
    LOCALES,
    SCREENS,
    INCLUDES,
    VARIATIONS,
    RTL,
    CUSTOM,
    API_LEVELS,
    NONE;

    private static Collection<String> ourDeletedIds;
    private static RenderPreviewMode ourCurrent;

    public static RenderPreviewMode getCurrent() {
        return ourCurrent;
    }

    public static void setCurrent(RenderPreviewMode current) {
        if (ourCurrent != current) {
            ourCurrent = current;
            ourDeletedIds = null;
        }
    }

    public static boolean isDeletedId(String id) {
        return ourDeletedIds != null && id != null && ourDeletedIds.contains(id);
    }

    public static void deleteId(String id) {
        if (id != null) {
            if (ourDeletedIds == null) {
                ourDeletedIds = Sets.newHashSet();
            }
            ourDeletedIds.add(id);
        }
    }

    public boolean showsDeviceFrames() {
        return this == SCREENS;
    }

    static {
        ourCurrent = NONE;
    }
}

