/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.ide.common.rendering.api.ViewInfo;
import com.android.tools.idea.rendering.RenderService;
import com.android.tools.idea.rendering.RenderedView;
import com.google.common.collect.Lists;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import java.util.ArrayList;
import java.util.List;

public class RenderedViewHierarchy {
    private final List<RenderedView> myRoots;
    private final PsiFile myFile;
    private final List<RenderedView> myIncludedRoots;

    private RenderedViewHierarchy(PsiFile file, List<RenderedView> roots, boolean computeIncludeBounds) {
        this.myFile = file;
        this.myRoots = roots;
        if (computeIncludeBounds) {
            this.myIncludedRoots = Lists.newArrayList();
            for (RenderedView root : this.myRoots) {
                this.addIncludedBounds(root);
            }
        } else {
            this.myIncludedRoots = null;
        }
    }

    public static RenderedViewHierarchy create(PsiFile file, List<ViewInfo> roots, boolean computeIncludeBounds) {
        return new RenderedViewHierarchy(file, RenderedViewHierarchy.convert(null, roots, 0, 0), computeIncludeBounds);
    }

    public List<RenderedView> getRoots() {
        return this.myRoots;
    }

    public List<RenderedView> getIncludedRoots() {
        return this.myIncludedRoots;
    }

    private static List<RenderedView> convert(RenderedView parent, List<ViewInfo> roots, int parentX, int parentY) {
        ArrayList<RenderedView> views = new ArrayList<RenderedView>(roots.size());
        for (ViewInfo info : roots) {
            XmlTag tag = null;
            Object cookie = info.getCookie();
            if (cookie instanceof XmlTag) {
                tag = (XmlTag)cookie;
            }
            ViewInfo bounds = RenderService.getSafeBounds(info);
            int x = bounds.getLeft();
            int y = bounds.getTop();
            int width = bounds.getRight() - x;
            int height = bounds.getBottom() - y;
            RenderedView view = new RenderedView(parent, info, tag, x += parentX, y += parentY, width, height);
            List children = info.getChildren();
            if (children != null && !children.isEmpty()) {
                view.setChildren(RenderedViewHierarchy.convert(view, children, x, y));
            }
            views.add(view);
        }
        return views;
    }

    private void addIncludedBounds(RenderedView view) {
        if (view.tag != null) {
            this.myIncludedRoots.add(view);
        } else {
            for (RenderedView child : view.getChildren()) {
                this.addIncludedBounds(child);
            }
        }
    }

    public List<RenderedView> findByOffset(int offset) {
        XmlTag tag = (XmlTag)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)this.myFile, (int)offset, XmlTag.class, (boolean)false);
        return tag != null ? this.findViewsByTag(tag) : null;
    }

    public RenderedView findLeafAt(int x, int y) {
        for (int i = this.myRoots.size() - 1; i >= 0; --i) {
            RenderedView view = this.myRoots.get(i);
            RenderedView leaf = view.findLeafAt(x, y);
            if (leaf == null) continue;
            return leaf;
        }
        return null;
    }

    public RenderedView findViewByTag(XmlTag tag) {
        for (RenderedView view : this.myRoots) {
            RenderedView match = view.findViewByTag(tag);
            if (match == null) continue;
            return match;
        }
        return null;
    }

    public List<RenderedView> findViewsByTag(XmlTag tag) {
        List<RenderedView> result = null;
        for (RenderedView view : this.myRoots) {
            List<RenderedView> matches = view.findViewsByTag(tag);
            if (matches == null) continue;
            if (result != null) {
                result.addAll(matches);
                continue;
            }
            result = matches;
        }
        return result;
    }
}

