/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.resources.ResourceType;
import com.android.tools.idea.gradle.project.GradleSyncListener;
import com.android.tools.idea.rendering.AppResourceRepository;
import com.android.tools.idea.rendering.LocalResourceRepository;
import com.android.tools.idea.rendering.ModuleResourceRepository;
import com.android.tools.idea.rendering.MultiResourceRepository;
import com.google.common.collect.Lists;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidUtils;

public final class ProjectResourceRepository
extends MultiResourceRepository {
    private final AndroidFacet myFacet;

    private ProjectResourceRepository(AndroidFacet facet, List<? extends LocalResourceRepository> delegates) {
        super(facet.getModule().getName() + " with modules", delegates);
        this.myFacet = facet;
    }

    public static ProjectResourceRepository getProjectResources(Module module, boolean createIfNecessary) {
        AndroidFacet facet = AndroidFacet.getInstance(module);
        if (facet != null) {
            return facet.getProjectResources(createIfNecessary);
        }
        return null;
    }

    public static ProjectResourceRepository getProjectResources(AndroidFacet facet, boolean createIfNecessary) {
        return facet.getProjectResources(createIfNecessary);
    }

    public static ProjectResourceRepository create(AndroidFacet facet) {
        List<LocalResourceRepository> resources = ProjectResourceRepository.computeRepositories(facet);
        final ProjectResourceRepository repository = new ProjectResourceRepository(facet, resources);
        facet.addListener(new GradleSyncListener.Adapter(){

            @Override
            public void syncSucceeded(Project project) {
                repository.updateRoots();
            }
        });
        return repository;
    }

    private static List<LocalResourceRepository> computeRepositories(AndroidFacet facet) {
        LocalResourceRepository main = ModuleResourceRepository.getModuleResources(facet, true);
        List<AndroidFacet> dependentFacets = AndroidUtils.getAllAndroidDependencies(facet.getModule(), true);
        if (dependentFacets.isEmpty()) {
            return Collections.singletonList(main);
        }
        ArrayList resources = Lists.newArrayListWithExpectedSize((int)dependentFacets.size());
        for (AndroidFacet f : dependentFacets) {
            LocalResourceRepository r = ModuleResourceRepository.getModuleResources(f, true);
            resources.add(r);
        }
        resources.add(main);
        return resources;
    }

    void updateRoots() {
        List<LocalResourceRepository> repositories = ProjectResourceRepository.computeRepositories(this.myFacet);
        this.updateRoots(repositories);
    }

    void updateRoots(List<LocalResourceRepository> resourceDirectories) {
        if (((Object)resourceDirectories).equals(this.myChildren)) {
            return;
        }
        this.setChildren(resourceDirectories);
    }

    public static void moduleRootsChanged(Project project) {
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
        for (Module module : moduleManager.getModules()) {
            ProjectResourceRepository.moduleRootsChanged(module);
        }
    }

    private static void moduleRootsChanged(Module module) {
        AndroidFacet facet = AndroidFacet.getInstance(module);
        if (facet != null) {
            if (facet.requiresAndroidModel() && facet.getAndroidModel() == null) {
                return;
            }
            ProjectResourceRepository projectResources = ProjectResourceRepository.getProjectResources(facet, false);
            if (projectResources != null) {
                projectResources.updateRoots();
                AppResourceRepository appResources = AppResourceRepository.getAppResources(facet, false);
                if (appResources != null) {
                    appResources.invalidateCache(projectResources, new ResourceType[0]);
                    appResources.updateRoots();
                }
            }
        }
    }

    static ProjectResourceRepository createForTest(AndroidFacet facet, List<LocalResourceRepository> modules) {
        return new ProjectResourceRepository(facet, modules);
    }
}

