/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.tools.idea.rendering.DynamicResourceValueRepository;
import com.android.tools.idea.rendering.LocalResourceRepository;
import com.android.tools.idea.rendering.MultiResourceRepository;
import com.android.tools.idea.rendering.ResourceFolderRegistry;
import com.android.tools.idea.rendering.ResourceFolderRepository;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.ResourceFolderManager;

public final class ModuleResourceRepository
extends MultiResourceRepository {
    private final AndroidFacet myFacet;

    private ModuleResourceRepository(AndroidFacet facet, List<? extends LocalResourceRepository> delegates) {
        super(facet.getModule().getName(), delegates);
        this.myFacet = facet;
    }

    public static LocalResourceRepository getModuleResources(Module module, boolean createIfNecessary) {
        AndroidFacet facet = AndroidFacet.getInstance(module);
        if (facet != null) {
            return facet.getModuleResources(createIfNecessary);
        }
        return null;
    }

    public static LocalResourceRepository getModuleResources(AndroidFacet facet, boolean createIfNecessary) {
        return facet.getModuleResources(createIfNecessary);
    }

    public static LocalResourceRepository create(AndroidFacet facet) {
        boolean gradleProject = facet.requiresAndroidModel();
        if (!gradleProject) {
            VirtualFile primaryResourceDir = facet.getPrimaryResourceDir();
            if (primaryResourceDir == null) {
                return new EmptyRepository();
            }
            return ResourceFolderRegistry.get(facet, primaryResourceDir);
        }
        ResourceFolderManager folderManager = facet.getResourceFolderManager();
        List<VirtualFile> resourceDirectories = folderManager.getFolders();
        ArrayList resources = Lists.newArrayListWithExpectedSize((int)resourceDirectories.size());
        for (VirtualFile resourceDirectory : resourceDirectories) {
            ResourceFolderRepository repository = ResourceFolderRegistry.get(facet, resourceDirectory);
            resources.add(repository);
        }
        DynamicResourceValueRepository dynamicResources = DynamicResourceValueRepository.create(facet);
        resources.add(dynamicResources);
        final ModuleResourceRepository repository = new ModuleResourceRepository(facet, (List<? extends LocalResourceRepository>)resources);
        folderManager.addListener(new ResourceFolderManager.ResourceFolderListener(){

            @Override
            public void resourceFoldersChanged(AndroidFacet facet, List<VirtualFile> folders, Collection<VirtualFile> added, Collection<VirtualFile> removed) {
                repository.updateRoots();
            }
        });
        return repository;
    }

    private void updateRoots() {
        this.updateRoots(this.myFacet.getResourceFolderManager().getFolders());
    }

    void updateRoots(List<VirtualFile> resourceDirectories) {
        List other = null;
        HashMap map = Maps.newHashMap();
        for (LocalResourceRepository repository : this.myChildren) {
            if (repository instanceof ResourceFolderRepository) {
                ResourceFolderRepository folderRepository = (ResourceFolderRepository)repository;
                VirtualFile resourceDir = folderRepository.getResourceDir();
                map.put(resourceDir, folderRepository);
                continue;
            }
            assert (repository instanceof DynamicResourceValueRepository);
            if (other == null) {
                other = Lists.newArrayList();
            }
            other.add(repository);
        }
        HashSet newDirs = Sets.newHashSet(resourceDirectories);
        ArrayList resources = Lists.newArrayListWithExpectedSize((int)(newDirs.size() + (other != null ? other.size() : 0)));
        for (VirtualFile dir : resourceDirectories) {
            ResourceFolderRepository repository = (ResourceFolderRepository)((Object)map.get(dir));
            if (repository == null) {
                repository = ResourceFolderRegistry.get(this.myFacet, dir);
            } else {
                map.remove(dir);
            }
            resources.add(repository);
        }
        if (other != null) {
            resources.addAll(other);
        }
        if (((Object)resources).equals(this.myChildren)) {
            assert (map.isEmpty());
            return;
        }
        for (ResourceFolderRepository removed : map.values()) {
            removed.removeParent(this);
        }
        this.setChildren(resources);
    }

    public static ModuleResourceRepository createForTest(AndroidFacet facet, List<VirtualFile> resourceDirectories) {
        assert (ApplicationManager.getApplication().isUnitTestMode());
        ArrayList resources = Lists.newArrayListWithExpectedSize((int)resourceDirectories.size());
        for (VirtualFile resourceDirectory : resourceDirectories) {
            ResourceFolderRepository repository = ResourceFolderRegistry.get(facet, resourceDirectory);
            resources.add(repository);
        }
        return new ModuleResourceRepository(facet, (List<? extends LocalResourceRepository>)resources);
    }

    private static class EmptyRepository
    extends MultiResourceRepository {
        public EmptyRepository() {
            super("", Collections.emptyList());
        }

        @Override
        protected void setChildren(List<? extends LocalResourceRepository> children) {
            this.myChildren = children;
        }
    }
}

