/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.tools.idea.configurations.OverlayContainer;
import com.android.tools.idea.rendering.Overlay;
import com.android.tools.idea.rendering.RenderedView;
import com.android.tools.idea.rendering.RenderedViewHierarchy;
import com.intellij.android.designer.designSurface.graphics.DesignerGraphics;
import com.intellij.android.designer.designSurface.graphics.DrawingStyle;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;

public class HoverOverlay
extends Overlay {
    private final OverlayContainer myContainer;
    private RenderedView myHoveredView;

    public HoverOverlay(OverlayContainer container) {
        this.myContainer = container;
    }

    public boolean setHoveredView(RenderedView view) {
        boolean changed;
        boolean bl = changed = view != this.myHoveredView;
        if (changed) {
            this.myHoveredView = view;
        }
        return changed;
    }

    @Override
    public void paint(Component component, Graphics2D gc, int deltaX, int deltaY) {
        if (component == null || this.myHoveredView == null) {
            return;
        }
        RenderedViewHierarchy viewHierarchy = this.myContainer.getViewHierarchy();
        if (viewHierarchy == null) {
            return;
        }
        boolean hoverIsSelected = this.myHoveredView.tag != null && this.myContainer.isSelected(this.myHoveredView.tag);
        DrawingStyle style = hoverIsSelected ? DrawingStyle.HOVER_SELECTION : DrawingStyle.HOVER;
        Rectangle r = this.myContainer.fromModel(component, this.myHoveredView.getBounds());
        Shape prevClip = gc.getClip();
        Shape clip = this.setScreenClip(this.myContainer, component, gc, deltaX, deltaY);
        DesignerGraphics.drawFilledRect(style, gc, r.x + deltaX, r.y + deltaY, r.width, r.height);
        if (clip != null) {
            gc.setClip(prevClip);
        }
    }
}

