/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profiling.view.nodes;

import com.android.tools.idea.profiling.capture.Capture;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.ui.treeStructure.SimpleTree;
import java.awt.event.InputEvent;

public class CaptureNode
extends SimpleNode {
    private final Capture myCapture;

    public CaptureNode(Project project, Capture capture) {
        super(project);
        this.myCapture = capture;
        this.getTemplatePresentation().addText(this.myCapture.getDescription(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        this.setIcon(this.myCapture.getType().getIcon());
    }

    public SimpleNode[] getChildren() {
        return new SimpleNode[0];
    }

    public boolean isAlwaysLeaf() {
        return true;
    }

    public Capture getCapture() {
        return this.myCapture;
    }

    public void handleDoubleClickOrEnter(SimpleTree tree, InputEvent inputEvent) {
        assert (this.myProject != null);
        OpenFileDescriptor descriptor = new OpenFileDescriptor(this.myProject, this.myCapture.getFile());
        try {
            FileEditorManager.getInstance((Project)this.myProject).openEditor(descriptor, true);
        }
        catch (IllegalArgumentException ignored) {
            // empty catch block
        }
    }

    protected void doUpdate() {
        this.getTemplatePresentation().clearText();
        this.getTemplatePresentation().addText(this.myCapture.getDescription(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
    }
}

