/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profiling.view;

import com.android.tools.idea.profiling.view.AnalysisContentsDelegate;
import com.android.tools.idea.profiling.view.AnalysisResultsManager;
import com.android.tools.idea.profiling.view.CaptureEditor;
import com.android.tools.perflib.analyzer.AnalysisReport;
import com.android.tools.perflib.analyzer.AnalyzerTask;
import com.intellij.designer.DesignerEditorPanelFacade;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.TaskInfo;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ThreeComponentsSplitter;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.impl.status.InlineProgressIndicator;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class CapturePanel
extends JPanel
implements DesignerEditorPanelFacade {
    private Project myProject;
    private CaptureEditor myEditor;
    private AnalyzerTask[] myTasks;
    private ThreeComponentsSplitter myThreeComponentsSplitter;
    private InlineProgressIndicator myProgressIndicator;
    private AnalysisContentsDelegate myResultsDelegate;
    private Runnable myFinishedLoadingCallback;

    public CapturePanel(Project project, CaptureEditor editor, AnalyzerTask[] tasks, boolean startAsLoading) {
        this.myProject = project;
        this.myEditor = editor;
        this.myTasks = tasks;
        this.myThreeComponentsSplitter = new ThreeComponentsSplitter(false);
        this.myThreeComponentsSplitter.setHonorComponentsMinimumSize(true);
        Disposer.register((Disposable)editor, (Disposable)this.myThreeComponentsSplitter);
        if (startAsLoading) {
            TaskInfo taskInfo = new TaskInfo(){

                public String getTitle() {
                    return "";
                }

                public String getCancelText() {
                    return null;
                }

                public String getCancelTooltipText() {
                    return null;
                }

                public boolean isCancellable() {
                    return false;
                }

                public String getProcessId() {
                    return null;
                }
            };
            this.myProgressIndicator = new InlineProgressIndicator(true, taskInfo){

                protected void queueProgressUpdate(Runnable update) {
                    ApplicationManager.getApplication().invokeLater(update);
                }

                protected void queueRunningUpdate(Runnable update) {
                    ApplicationManager.getApplication().invokeLater(update);
                }
            };
            this.setLayout(new GridBagLayout());
            this.add(this.myProgressIndicator.getComponent());
        }
    }

    public void setEditorPanel(final JComponent editorPanel, final AnalysisContentsDelegate delegate) {
        assert (!this.isDoneLoading());
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                CapturePanel.this.removeAll();
                CapturePanel.this.myProgressIndicator = null;
                CapturePanel.this.myResultsDelegate = delegate;
                CapturePanel.this.setLayout(new BorderLayout());
                CapturePanel.this.myThreeComponentsSplitter.setInnerComponent(editorPanel);
                AnalysisResultsManager.getInstance(CapturePanel.this.myProject).bind(CapturePanel.this);
                CapturePanel.this.add((Component)CapturePanel.this.myThreeComponentsSplitter, "Center");
                if (CapturePanel.this.myFinishedLoadingCallback != null) {
                    CapturePanel.this.myFinishedLoadingCallback.run();
                    CapturePanel.this.myFinishedLoadingCallback = null;
                }
            }
        });
    }

    public ThreeComponentsSplitter getContentSplitter() {
        return this.myThreeComponentsSplitter;
    }

    public InlineProgressIndicator getProgressIndicator() {
        return this.myProgressIndicator;
    }

    public boolean isDoneLoading() {
        return this.myProgressIndicator == null;
    }

    public AnalyzerTask[] getAnalyzerTasks() {
        return this.myTasks;
    }

    public AnalysisReport performAnalysis(Set<? extends AnalyzerTask> tasks, Set<AnalysisReport.Listener> listeners) {
        return this.myEditor.performAnalysis(tasks, listeners);
    }

    public AnalysisContentsDelegate getContentsDelegate() {
        assert (this.myResultsDelegate != null);
        return this.myResultsDelegate;
    }

    public CaptureEditor getEditor() {
        return this.myEditor;
    }

    public void runWhenFinishedLoading(Runnable callback) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myFinishedLoadingCallback = callback;
        if (this.isDoneLoading()) {
            this.myFinishedLoadingCallback.run();
            this.myFinishedLoadingCallback = null;
        }
    }
}

