/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profiling.view;

import com.android.tools.idea.profiling.view.AnalysisResultsContent;
import com.android.tools.idea.profiling.view.CaptureEditorLightToolWindowManager;
import com.android.tools.idea.profiling.view.CapturePanel;
import com.android.tools.idea.profiling.view.EmptyManager;
import com.intellij.designer.DesignerEditorPanelFacade;
import com.intellij.designer.LightToolWindow;
import com.intellij.designer.LightToolWindowManager;
import com.intellij.designer.ToggleEditorModeAction;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindowAnchor;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.android.util.AndroidBundle;

public class AnalysisResultsManager
extends CaptureEditorLightToolWindowManager {
    private AnalysisResultsContent myContent = new AnalysisResultsContent();

    public static AnalysisResultsManager getInstance(Project project) {
        return (AnalysisResultsManager)((Object)project.getComponent(AnalysisResultsManager.class));
    }

    protected AnalysisResultsManager(Project project, FileEditorManager fileEditorManager) {
        super(project, fileEditorManager);
    }

    protected void updateToolWindow(DesignerEditorPanelFacade designer) {
        this.myContent.update(designer);
        if (designer == null) {
            this.myToolWindow.setAvailable(false, null);
        } else {
            DesignerEditorPanelFacade activeDesigner = this.getActiveDesigner();
            if (activeDesigner != null && activeDesigner instanceof CapturePanel && activeDesigner.getClientProperty((Object)this.getComponentName()) == null) {
                activeDesigner.putClientProperty((Object)this.getComponentName(), (Object)this.myContent);
            }
            this.myToolWindow.setIcon(this.getIcon());
            this.myToolWindow.setAvailable(true, null);
            this.myToolWindow.show(null);
        }
    }

    @Override
    protected Icon getIcon() {
        return this.myContent.getIcon() == null ? AllIcons.Toolwindows.ToolWindowFind : this.myContent.getIcon();
    }

    @Override
    protected String getManagerName() {
        return AndroidBundle.message("android.captures.analysis.results.manager.name", new Object[0]);
    }

    @Override
    protected String getToolWindowTitleBarText() {
        return AndroidBundle.message("android.captures.analysis.results.manager.titlebar.text", new Object[0]);
    }

    @Override
    protected AnAction[] createActions() {
        return new AnAction[]{new ToggleAction(AndroidBundle.message("android.captures.analysis.results.manager.run.name", new Object[0]), AndroidBundle.message("android.captures.analysis.results.manager.run.description", new Object[0]), AllIcons.Toolwindows.ToolWindowRun){

            public boolean isSelected(AnActionEvent e) {
                AnalysisResultsContent analysisResultsContent = AnalysisResultsManager.this.getContentFromDesigner();
                return analysisResultsContent != null && !analysisResultsContent.canRunAnalysis();
            }

            public void setSelected(AnActionEvent e, boolean state) {
                AnalysisResultsContent analysisResultsContent;
                if (state && (analysisResultsContent = AnalysisResultsManager.this.getContentFromDesigner()) != null && analysisResultsContent.canRunAnalysis()) {
                    analysisResultsContent.performAnalysis();
                }
            }

            public void update(AnActionEvent e) {
                super.update(e);
                Presentation presentation = e.getPresentation();
                if (this.isSelected(e)) {
                    presentation.setText(AndroidBundle.message("android.captures.analysis.results.manager.run.disabled.name", new Object[0]));
                    presentation.setDescription(AndroidBundle.message("android.captures.analysis.results.manager.run.disabled.description", new Object[0]));
                    presentation.setIcon(AllIcons.Process.DisabledRun);
                } else {
                    presentation.setText(AndroidBundle.message("android.captures.analysis.results.manager.run.enabled.name", new Object[0]));
                    presentation.setDescription(AndroidBundle.message("android.captures.analysis.results.manager.run.enabled.description", new Object[0]));
                    presentation.setIcon(AllIcons.Toolwindows.ToolWindowRun);
                }
            }
        }};
    }

    @Override
    protected JComponent getContent() {
        return this.myContent.getMainPanel();
    }

    @Override
    protected JComponent getFocusedComponent() {
        return this.myContent.getFocusComponent();
    }

    protected ToolWindowAnchor getAnchor() {
        return ToolWindowAnchor.RIGHT;
    }

    public String getComponentName() {
        return "CaptureAnalysis";
    }

    public void disposeComponent() {
        this.myContent.dispose();
    }

    protected LightToolWindow createContent(DesignerEditorPanelFacade designer) {
        AnalysisResultsContent content = new AnalysisResultsContent();
        content.update(designer);
        Icon icon = content.getIcon();
        if (icon == null) {
            icon = this.getIcon();
        }
        JComponent focus = content.getFocusComponent();
        LightToolWindow lightToolWindow = this.createContent(designer, content, this.getToolWindowTitleBarText(), icon, content.getMainPanel(), focus == null ? content.getMainPanel() : focus, 320, this.createActions());
        lightToolWindow.minimize();
        return lightToolWindow;
    }

    protected ToggleEditorModeAction createToggleAction(ToolWindowAnchor anchor) {
        return new ToggleEditorModeAction(this, this.myProject, anchor){

            protected LightToolWindowManager getOppositeManager() {
                return EmptyManager.getInstance(this.myProject);
            }
        };
    }

    private AnalysisResultsContent getContentFromDesigner() {
        DesignerEditorPanelFacade activeDesigner = this.getActiveDesigner();
        if (activeDesigner != null && activeDesigner instanceof CapturePanel) {
            Object property = activeDesigner.getClientProperty((Object)this.getComponentName());
            if (property instanceof LightToolWindow) {
                LightToolWindow lightToolWindow = (LightToolWindow)property;
                Object content = lightToolWindow.getContent();
                if (content instanceof AnalysisResultsContent) {
                    return (AnalysisResultsContent)content;
                }
            } else if (property instanceof AnalysisResultsContent) {
                return (AnalysisResultsContent)property;
            }
        }
        return null;
    }
}

