/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw;

import com.android.tools.idea.npw.CircularParameterDependencyException;
import com.android.tools.idea.templates.Parameter;
import com.android.tools.idea.templates.StringEvaluator;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.openapi.util.text.StringUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public final class ParameterDefaultValueComputer {
    private static final Deduplicator DO_NOTHING_DEDUPLICATOR = new Deduplicator(){

        @Override
        public String deduplicate(Parameter parameter, String value) {
            return value;
        }
    };
    private final Set<Parameter> myComputedParameters = Sets.newHashSet();
    private final Set<Parameter> myStaticParameters = Sets.newHashSet();
    private final Deduplicator myDeduplicator;
    private final StringEvaluator myStringEvaluator = new StringEvaluator();
    private final Map<Parameter, Object> myUserValues;
    private final Map<String, Object> myImplicitParameters;

    private static Object decodeInitialValue(Parameter input, String initial) {
        if (initial != null && input.type == Parameter.Type.BOOLEAN) {
            return Boolean.valueOf(initial);
        }
        return initial;
    }

    public ParameterDefaultValueComputer(Iterable<Parameter> parameters, Map<Parameter, Object> userValues, Map<String, Object> implicitParameters, Deduplicator deduplicator) {
        this.myUserValues = userValues;
        this.myImplicitParameters = implicitParameters;
        for (Parameter parameter : parameters) {
            if (parameter == null || StringUtil.isEmptyOrSpaces((String)parameter.id)) continue;
            if (!StringUtil.isEmptyOrSpaces((String)parameter.suggest) && !userValues.containsKey(parameter)) {
                this.myComputedParameters.add(parameter);
                continue;
            }
            this.myStaticParameters.add(parameter);
        }
        this.myDeduplicator = deduplicator == null ? DO_NOTHING_DEDUPLICATOR : deduplicator;
    }

    public Map<Parameter, Object> getParameterValues() throws CircularParameterDependencyException {
        Map<String, Object> staticValues = this.getStaticParameterValues(this.myUserValues, this.myImplicitParameters);
        Map<String, Object> computedValues = this.computeParameterValues(staticValues);
        HashMap allValues = Maps.newHashMapWithExpectedSize((int)(computedValues.size() + staticValues.size()));
        for (Parameter parameter : Iterables.concat(this.myStaticParameters, this.myComputedParameters)) {
            allValues.put(parameter, computedValues.get(parameter.id));
        }
        return allValues;
    }

    private Object computeParameterValue(Parameter computedParameter, Map<String, Object> currentValues) {
        String suggest = computedParameter.suggest;
        assert (!StringUtil.isEmptyOrSpaces((String)suggest));
        String value = this.myStringEvaluator.evaluate(suggest, currentValues);
        value = this.myDeduplicator.deduplicate(computedParameter, value);
        return ParameterDefaultValueComputer.decodeInitialValue(computedParameter, value);
    }

    private Map<String, Object> getStaticParameterValues(Map<Parameter, Object> values, Map<String, Object> implicitParameters) {
        HashMap knownValues = Maps.newHashMapWithExpectedSize((int)(this.myStaticParameters.size() + implicitParameters.size()));
        knownValues.putAll(implicitParameters);
        for (Parameter parameter : this.myStaticParameters) {
            Object value;
            if (values.containsKey(parameter)) {
                value = values.get(parameter);
            } else {
                String initial = parameter.initial;
                value = ParameterDefaultValueComputer.decodeInitialValue(parameter, initial);
            }
            knownValues.put(parameter.id, value);
        }
        return knownValues;
    }

    private Map<String, Object> computeParameterValues(Map<String, Object> staticValues) throws CircularParameterDependencyException {
        HashMap computedValues = Maps.newHashMapWithExpectedSize((int)(this.myComputedParameters.size() + staticValues.size()));
        computedValues.putAll(staticValues);
        for (Parameter parameter : this.myComputedParameters) {
            computedValues.put(parameter.id, "");
        }
        int maxIterations = 2 * this.myComputedParameters.size();
        Object updatedValues = ImmutableMap.of();
        for (int i = 0; i <= maxIterations; ++i) {
            updatedValues = this.computeUpdatedValues(computedValues);
            if (updatedValues.isEmpty()) {
                return computedValues;
            }
            computedValues.putAll(updatedValues);
        }
        throw new CircularParameterDependencyException(updatedValues.keySet());
    }

    private Map<String, Object> computeUpdatedValues(Map<String, Object> values) {
        HashMap updatedValues = Maps.newHashMapWithExpectedSize((int)this.myComputedParameters.size());
        for (Parameter computedParameter : this.myComputedParameters) {
            Object value = this.computeParameterValue(computedParameter, values);
            String id = computedParameter.id;
            if (Objects.equal((Object)values.get(id), (Object)value)) continue;
            updatedValues.put(id, value);
        }
        return updatedValues;
    }

    public static interface Deduplicator {
        public String deduplicate(Parameter var1, String var2);
    }
}

