/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw;

import com.android.builder.model.SourceProvider;
import com.android.tools.idea.wizard.template.TemplateWizardState;
import com.android.tools.idea.wizard.template.TemplateWizardStep;
import com.google.common.collect.Lists;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ArrayUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.IdeaSourceProvider;

public class ChooseSourceSetStep
extends TemplateWizardStep {
    private JCheckBox myShowAllCheckBox;
    private JBLabel myDescription;
    private JBList mySourceSetList;
    private JPanel myPanel;
    private JBScrollPane mySourceSetListScrollPane;
    private JBLabel myInstructions;
    private List<SourceProvider> myFilteredSourceProviders;
    private List<SourceProvider> myAllSourceProviders;
    private final SourceProviderSelectedListener mySelectionListener;

    public ChooseSourceSetStep(TemplateWizardState state, Project project, Module module, Icon sidePanelIcon, TemplateWizardStep.UpdateListener updateListener, SourceProviderSelectedListener selectionListener, List<SourceProvider> sourceProviders) {
        super(state, project, module, sidePanelIcon, updateListener);
        this.mySelectionListener = selectionListener;
        this.$$$setupUI$$$();
        this.mySourceSetList.setSelectionMode(0);
        this.mySourceSetListScrollPane.setBorder(BorderFactory.createLoweredBevelBorder());
        this.myInstructions.setText("<html>The selected folder contains multiple source sets <br>(this can include source sets that do not yet exist on disk).<br>Please select the target source set in which to create the files.</html>");
        this.growLabelIfNecessary((JLabel)this.myInstructions);
        this.myFilteredSourceProviders = sourceProviders;
        AndroidFacet facet = AndroidFacet.getInstance(module);
        assert (facet != null);
        this.myAllSourceProviders = IdeaSourceProvider.getAllSourceProviders(facet);
        if (this.myFilteredSourceProviders.isEmpty()) {
            this.myFilteredSourceProviders = this.myAllSourceProviders;
            this.myShowAllCheckBox.setSelected(true);
            this.myShowAllCheckBox.setEnabled(false);
        }
        this.setSourceProviders(this.myFilteredSourceProviders);
        this.mySourceSetList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (ChooseSourceSetStep.this.mySourceSetList.getSelectedIndex() == -1) {
                    ChooseSourceSetStep.this.mySourceSetList.setSelectedIndex(0);
                }
                SourceProviderListItem selectedItem = (SourceProviderListItem)ChooseSourceSetStep.this.mySourceSetList.getModel().getElementAt(ChooseSourceSetStep.this.mySourceSetList.getSelectedIndex());
                ChooseSourceSetStep.this.mySelectionListener.sourceProviderSelected(selectedItem.myProvider);
            }
        });
        this.myShowAllCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    ChooseSourceSetStep.this.setSourceProviders(ChooseSourceSetStep.this.myAllSourceProviders);
                } else {
                    ChooseSourceSetStep.this.setSourceProviders(ChooseSourceSetStep.this.myFilteredSourceProviders);
                }
            }
        });
    }

    private void setSourceProviders(List<SourceProvider> sourceProviders) {
        ArrayList sourceProviderListItemList = Lists.newArrayListWithCapacity((int)sourceProviders.size());
        for (SourceProvider provider : sourceProviders) {
            sourceProviderListItemList.add(new SourceProviderListItem(provider, provider.getName()));
        }
        this.mySourceSetList.setModel((ListModel)JBList.createDefaultListModel((Object[])ArrayUtil.toObjectArray((Collection)sourceProviderListItemList)));
        this.mySourceSetList.setSelectedIndex(0);
    }

    @Override
    protected JLabel getDescription() {
        return this.myDescription;
    }

    @Override
    protected JLabel getError() {
        return this.myDescription;
    }

    @Override
    public JComponent getComponent() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        JBList jBList;
        JBScrollPane jBScrollPane;
        JCheckBox jCheckBox;
        JBLabel jBLabel2;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myInstructions = jBLabel2 = new JBLabel();
        jBLabel2.setText("");
        jPanel.add((Component)jBLabel2, new GridConstraints(3, 0, 1, 1, 0, 1, 7, 0, new Dimension(-1, 120), null, null));
        this.myShowAllCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Show All");
        jPanel.add((Component)jCheckBox, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.mySourceSetListScrollPane = jBScrollPane = new JBScrollPane();
        jPanel.add((Component)jBScrollPane, new GridConstraints(1, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        this.mySourceSetList = jBList = new JBList();
        jBScrollPane.setViewportView((Component)jBList);
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setText("Select a Target Source Set");
        jPanel.add((Component)jBLabel3, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myDescription = jBLabel = new JBLabel();
        jPanel.add((Component)jBLabel, new GridConstraints(4, 0, 1, 1, 0, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    public static interface SourceProviderSelectedListener {
        public void sourceProviderSelected(SourceProvider var1);
    }

    private static class SourceProviderListItem {
        private SourceProvider myProvider;
        private String myDisplayName;

        public SourceProviderListItem(SourceProvider provider, String displayName) {
            this.myProvider = provider;
            this.myDisplayName = displayName;
        }

        public String toString() {
            return this.myDisplayName;
        }
    }
}

