/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes;

import com.android.tools.idea.navigator.nodes.DirectoryGroupNode;
import com.android.tools.idea.navigator.nodes.NonAndroidSourceType;
import com.google.common.collect.Lists;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.ProjectViewDirectoryHelper;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiManager;
import com.intellij.ui.SimpleTextAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class NonAndroidSourceTypeNode
extends ProjectViewNode<Module>
implements DirectoryGroupNode {
    private final NonAndroidSourceType mySourceType;

    public NonAndroidSourceTypeNode(Project project, Module module, ViewSettings settings, NonAndroidSourceType type) {
        super(project, (Object)module, settings);
        this.mySourceType = type;
    }

    public Collection<? extends AbstractTreeNode> getChildren() {
        List<VirtualFile> sourceFolders = this.getSourceFolders();
        ArrayList children = Lists.newArrayListWithExpectedSize((int)sourceFolders.size());
        PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
        ProjectViewDirectoryHelper directoryHelper = ProjectViewDirectoryHelper.getInstance((Project)this.myProject);
        for (VirtualFile file : sourceFolders) {
            PsiDirectory dir = psiManager.findDirectory(file);
            if (dir == null) continue;
            children.addAll(directoryHelper.getDirectoryChildren(dir, this.getSettings(), true));
        }
        return children;
    }

    private List<VirtualFile> getSourceFolders() {
        ContentEntry[] contentEntries;
        ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)((Module)this.getValue()));
        ArrayList folders = Lists.newArrayList();
        for (ContentEntry entry : contentEntries = rootManager.getContentEntries()) {
            List sources = entry.getSourceFolders(this.mySourceType.rootType);
            for (SourceFolder folder : sources) {
                VirtualFile file = folder.getFile();
                if (file == null) continue;
                folders.add(file);
            }
        }
        return folders;
    }

    protected void update(PresentationData presentation) {
        presentation.addText(this.mySourceType.presentableName, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        presentation.setPresentableText(this.mySourceType.presentableName);
        presentation.setIcon(this.mySourceType.icon);
    }

    public boolean contains(VirtualFile file) {
        for (VirtualFile folder : this.getSourceFolders()) {
            if (!VfsUtilCore.isAncestor((VirtualFile)folder, (VirtualFile)file, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    public Comparable getSortKey() {
        return this.mySourceType;
    }

    public Comparable getTypeSortKey() {
        return this.mySourceType;
    }

    public String toTestString(Queryable.PrintInfo printInfo) {
        return this.mySourceType.presentableName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NonAndroidSourceTypeNode that = (NonAndroidSourceTypeNode)o;
        return this.mySourceType == that.mySourceType;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.mySourceType.hashCode();
        return result;
    }

    @Override
    public PsiDirectory[] getDirectories() {
        PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
        List<VirtualFile> sourceFolders = this.getSourceFolders();
        ArrayList psiDirectories = Lists.newArrayListWithExpectedSize((int)sourceFolders.size());
        for (VirtualFile f : sourceFolders) {
            PsiDirectory dir = psiManager.findDirectory(f);
            if (dir == null) continue;
            psiDirectories.add(dir);
        }
        return psiDirectories.toArray(new PsiDirectory[psiDirectories.size()]);
    }
}

