/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes;

import com.android.tools.idea.navigator.nodes.AndroidManifestFileNode;
import com.android.tools.idea.navigator.nodes.DirectoryGroupNode;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.SimpleTextAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidSourceType;
import org.jetbrains.android.facet.IdeaSourceProvider;

public class AndroidManifestsGroupNode
extends ProjectViewNode<AndroidFacet>
implements DirectoryGroupNode {
    private static final String MANIFESTS_NODE = "manifests";
    private final Set<VirtualFile> mySources;

    protected AndroidManifestsGroupNode(Project project, AndroidFacet facet, ViewSettings viewSettings, Set<VirtualFile> sources) {
        super(project, (Object)facet, viewSettings);
        this.mySources = sources;
    }

    public boolean contains(VirtualFile file) {
        return this.mySources.contains(file);
    }

    public Collection<? extends AbstractTreeNode> getChildren() {
        PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
        ArrayList children = Lists.newArrayList();
        for (VirtualFile manifest : this.mySources) {
            PsiFile psiFile;
            if (!manifest.isValid() || (psiFile = psiManager.findFile(manifest)) == null) continue;
            AndroidFacet facet = (AndroidFacet)((Object)this.getValue());
            assert (facet != null) : "Android Facet for module cannot be null";
            children.add(new AndroidManifestFileNode(this.myProject, psiFile, this.getSettings(), facet));
        }
        return children;
    }

    protected void update(PresentationData presentation) {
        presentation.addText(MANIFESTS_NODE, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        Icon icon = AndroidSourceType.MANIFEST.getIcon();
        if (icon != null) {
            presentation.setIcon(icon);
        }
        presentation.setPresentableText(MANIFESTS_NODE);
    }

    public boolean expandOnDoubleClick() {
        return false;
    }

    public boolean canNavigate() {
        return !this.mySources.isEmpty();
    }

    public void navigate(boolean requestFocus) {
        VirtualFile fileToOpen = this.findFileToOpen(this.mySources);
        if (fileToOpen == null) {
            return;
        }
        new OpenFileDescriptor(this.myProject, fileToOpen).navigate(requestFocus);
    }

    private VirtualFile findFileToOpen(Set<VirtualFile> files) {
        VirtualFile bestFile = (VirtualFile)Iterables.getFirst(files, null);
        PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
        for (VirtualFile f : files) {
            IdeaSourceProvider sourceProvider;
            PsiFile psiFile = psiManager.findFile(f);
            if (psiFile == null || (sourceProvider = AndroidManifestFileNode.getSourceProvider((AndroidFacet)((Object)this.getValue()), psiFile)) == null || !"main".equals(sourceProvider.getName())) continue;
            bestFile = f;
        }
        return bestFile;
    }

    @Override
    public PsiDirectory[] getDirectories() {
        return PsiDirectory.EMPTY_ARRAY;
    }

    public Comparable getSortKey() {
        return AndroidSourceType.MANIFEST;
    }

    public Comparable getTypeSortKey() {
        return AndroidSourceType.MANIFEST;
    }

    public String toTestString(Queryable.PrintInfo printInfo) {
        return MANIFESTS_NODE;
    }
}

