/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes;

import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.lang.proguard.ProguardFileType;
import com.android.tools.idea.navigator.nodes.AndroidBuildScriptNode;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import icons.GradleIcons;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AndroidBuildScriptsGroupNode
extends ProjectViewNode<List<PsiDirectory>> {
    public AndroidBuildScriptsGroupNode(Project project, ViewSettings viewSettings) {
        super(project, Collections.emptyList(), viewSettings);
    }

    public boolean contains(VirtualFile file) {
        return this.getBuildScriptsWithQualifiers().containsKey(file);
    }

    public Collection<? extends AbstractTreeNode> getChildren() {
        Map<VirtualFile, String> scripts = this.getBuildScriptsWithQualifiers();
        ArrayList children = Lists.newArrayListWithExpectedSize((int)scripts.size());
        for (Map.Entry<VirtualFile, String> scriptWithQualifier : scripts.entrySet()) {
            this.addPsiFile(children, scriptWithQualifier.getKey(), scriptWithQualifier.getValue());
        }
        return children;
    }

    private Map<VirtualFile, String> getBuildScriptsWithQualifiers() {
        File userSettingsFile;
        HashMap buildScripts = Maps.newHashMap();
        for (Module m : ModuleManager.getInstance((Project)this.myProject).getModules()) {
            String moduleName = AndroidBuildScriptsGroupNode.getPrefixForModule(m) + m.getName();
            buildScripts.put(GradleUtil.getGradleBuildFile(m), moduleName);
            for (VirtualFile f : AndroidBuildScriptsGroupNode.findAllGradleScriptsInModule(m)) {
                if (f.getFileType() == ProguardFileType.INSTANCE) {
                    buildScripts.put(f, String.format("ProGuard Rules for %1$s", m.getName()));
                    continue;
                }
                buildScripts.put(f, moduleName);
            }
        }
        VirtualFile baseDir = this.myProject.getBaseDir();
        buildScripts.put(baseDir.findChild("settings.gradle"), "Project Settings");
        buildScripts.put(baseDir.findChild("gradle.properties"), "Project Properties");
        buildScripts.put(baseDir.findFileByRelativePath(GradleUtil.GRADLEW_PROPERTIES_PATH), "Gradle Version");
        buildScripts.put(baseDir.findChild("local.properties"), "SDK Location");
        if (!ApplicationManager.getApplication().isUnitTestMode() && (userSettingsFile = GradleUtil.getGradleUserSettingsFile()) != null) {
            buildScripts.put(VfsUtil.findFileByIoFile((File)userSettingsFile, (boolean)false), "Global Properties");
        }
        buildScripts.remove(null);
        return buildScripts;
    }

    private static String getPrefixForModule(Module m) {
        return GradleUtil.isRootModuleWithNoSources(m) ? "Project: " : "Module: ";
    }

    private static List<VirtualFile> findAllGradleScriptsInModule(Module m) {
        File moduleDir = new File(m.getModuleFilePath()).getParentFile();
        VirtualFile dir = VfsUtil.findFileByIoFile((File)moduleDir, (boolean)false);
        if (dir == null || dir.getChildren() == null) {
            return Collections.emptyList();
        }
        ArrayList files = Lists.newArrayList();
        for (VirtualFile child : dir.getChildren()) {
            if (!child.isValid() || child.isDirectory() || !child.getName().endsWith("gradle") && child.getFileType() != ProguardFileType.INSTANCE || ApplicationManager.getApplication().isUnitTestMode() && (child.getName().startsWith("ijinit") || child.getName().startsWith("asLocalRepo"))) continue;
            files.add(child);
        }
        return files;
    }

    private void addPsiFile(List<PsiFileNode> psiFileNodes, VirtualFile file, String qualifier) {
        if (file == null) {
            return;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)this.myProject).findFile(file);
        if (psiFile != null) {
            psiFileNodes.add(new AndroidBuildScriptNode(this.myProject, psiFile, this.getSettings(), qualifier));
        }
    }

    public int getWeight() {
        return 100;
    }

    protected void update(PresentationData presentation) {
        presentation.setPresentableText("Gradle Scripts");
        presentation.setIcon(GradleIcons.Gradle);
    }

    public String toTestString(Queryable.PrintInfo printInfo) {
        return "Gradle Scripts";
    }
}

