/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.monitor.actions;

import com.android.tools.idea.monitor.BaseMonitorView;
import com.android.tools.idea.stats.UsageTracker;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;

public class RecordingAction
extends ToggleAction {
    private final BaseMonitorView myMonitorView;

    public RecordingAction(BaseMonitorView monitorView) {
        super(null, null, AllIcons.Actions.Pause);
        this.myMonitorView = monitorView;
    }

    public boolean isSelected(AnActionEvent e) {
        return this.myMonitorView.isPaused();
    }

    public void update(AnActionEvent e) {
        super.update(e);
        Presentation presentation = e.getPresentation();
        if (this.isSelected(e)) {
            presentation.setText("Disabled");
            presentation.setDescription("Click to enable " + this.myMonitorView.getDescription() + " recording.");
        } else {
            presentation.setText("Enabled");
            presentation.setDescription("Click to disable " + this.myMonitorView.getDescription() + " recording.");
        }
    }

    public void setSelected(AnActionEvent e, boolean state) {
        if (this.myMonitorView.isPaused() != state) {
            UsageTracker.getInstance().trackEvent("profiling", "runningMonitor", this.myMonitorView.getDescription(), state ? 0 : 1);
        }
        this.myMonitorView.setPaused(state);
    }
}

