/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.monitor;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.ClientData;
import com.android.tools.idea.ddms.DeviceContext;
import com.android.tools.idea.ddms.DevicePanel;
import com.android.tools.idea.ddms.EdtExecutor;
import com.android.tools.idea.ddms.OpenVmTraceHandler;
import com.android.tools.idea.ddms.actions.DumpSysActions;
import com.android.tools.idea.ddms.actions.ScreenRecorderAction;
import com.android.tools.idea.ddms.actions.ScreenshotAction;
import com.android.tools.idea.ddms.actions.TerminateVMAction;
import com.android.tools.idea.ddms.adb.AdbService;
import com.android.tools.idea.logcat.AndroidLogcatView;
import com.android.tools.idea.monitor.BaseMonitorView;
import com.android.tools.idea.monitor.DeviceSampler;
import com.android.tools.idea.monitor.cpu.CpuMonitorView;
import com.android.tools.idea.monitor.gpu.GpuMonitorView;
import com.android.tools.idea.monitor.memory.MemoryMonitorView;
import com.android.tools.idea.monitor.network.NetworkMonitorView;
import com.android.tools.idea.stats.UsageTracker;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.ProjectTopics;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.execution.ui.layout.PlaceInGrid;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootAdapter;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowFactory;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerAdapter;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerAdapter;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.util.messages.MessageBusConnection;
import icons.AndroidIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.io.File;
import java.util.List;
import java.util.concurrent.Executor;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.maven.AndroidMavenUtil;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.android.util.AndroidBundle;

public class AndroidToolWindowFactory
implements ToolWindowFactory,
DumbAware {
    public static final String TOOL_WINDOW_ID = AndroidBundle.message("android.logcat.title", new Object[0]);
    private static final String ADBLOGS_CONTENT_ID = "AdbLogsContent";
    public static final Key<DevicePanel> DEVICES_PANEL_KEY = Key.create((String)"DevicePanel");

    public void createToolWindowContent(final Project project, ToolWindow toolWindow) {
        ExecutionManager.getInstance((Project)project).getContentManager();
        RunnerLayoutUi layoutUi = RunnerLayoutUi.Factory.getInstance((Project)project).create("Android", TOOL_WINDOW_ID, "Profiling Tools", (Disposable)project);
        toolWindow.setIcon(AndroidIcons.AndroidToolWindow);
        toolWindow.setAvailable(true, null);
        toolWindow.setToHideOnEmptyContent(true);
        toolWindow.setTitle(TOOL_WINDOW_ID);
        DeviceContext deviceContext = new DeviceContext();
        ClientData.setMethodProfilingHandler((ClientData.IMethodProfilingHandler)new OpenVmTraceHandler(project));
        Content logcatContent = AndroidToolWindowFactory.createLogcatContent(layoutUi, project, deviceContext);
        final AndroidLogcatView logcatView = (AndroidLogcatView)logcatContent.getUserData(AndroidLogcatView.ANDROID_LOGCAT_VIEW_KEY);
        assert (logcatView != null);
        logcatContent.setSearchComponent((JComponent)logcatView.createSearchComponent());
        layoutUi.addContent(logcatContent, 0, PlaceInGrid.center, false);
        final ViewContent memoryViewContent = AndroidToolWindowFactory.createMemoryViewContent(layoutUi, project, deviceContext);
        layoutUi.addContent(memoryViewContent.myContent, 1, PlaceInGrid.center, false);
        final ViewContent cpuViewContent = AndroidToolWindowFactory.createCpuViewContent(layoutUi, project, deviceContext);
        layoutUi.addContent(cpuViewContent.myContent, 2, PlaceInGrid.center, false);
        final ViewContent gpuViewContent = AndroidToolWindowFactory.createGpuViewContent(layoutUi, project, deviceContext);
        layoutUi.addContent(gpuViewContent.myContent, 3, PlaceInGrid.center, false);
        final ViewContent networkViewContent = AndroidToolWindowFactory.createNetworkViewContent(layoutUi, project, deviceContext);
        layoutUi.addContent(networkViewContent.myContent, 4, PlaceInGrid.center, false);
        layoutUi.getOptions().setLeftToolbar(this.getToolbarActions(project, deviceContext), "unknown");
        layoutUi.addListener((ContentManagerListener)new ContentManagerAdapter(){

            public void selectionChanged(ContentManagerEvent event) {
                Content selectedContent = event.getContent();
                String eventLabel = null;
                if (selectedContent == memoryViewContent.myContent) {
                    eventLabel = memoryViewContent.myView.getDescription();
                } else if (selectedContent == cpuViewContent.myContent) {
                    eventLabel = cpuViewContent.myView.getDescription();
                } else if (selectedContent == gpuViewContent.myContent) {
                    eventLabel = gpuViewContent.myView.getDescription();
                } else if (selectedContent == networkViewContent.myContent) {
                    eventLabel = networkViewContent.myView.getDescription();
                }
                if (eventLabel != null && event.getOperation() == ContentManagerEvent.ContentOperation.add) {
                    UsageTracker.getInstance().trackEvent("monitors", "activateMonitor", eventLabel, null);
                }
            }
        }, (Disposable)project);
        final JBLoadingPanel loadingPanel = new JBLoadingPanel((LayoutManager)new BorderLayout(), (Disposable)project);
        DevicePanel devicePanel = new DevicePanel(project, deviceContext);
        JPanel panel = devicePanel.getComponent();
        panel.setBorder(IdeBorderFactory.createBorder((int)8));
        loadingPanel.add((Component)panel, (Object)"North");
        loadingPanel.add((Component)layoutUi.getComponent(), (Object)"Center");
        ContentManager contentManager = toolWindow.getContentManager();
        Content c = contentManager.getFactory().createContent((JComponent)loadingPanel, "", true);
        c.putUserData(AndroidLogcatView.ANDROID_LOGCAT_VIEW_KEY, (Object)logcatView);
        c.putUserData(DEVICES_PANEL_KEY, (Object)devicePanel);
        contentManager.addContent(c);
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                ConsoleView console;
                logcatView.activate();
                ToolWindow window = ToolWindowManager.getInstance((Project)project).getToolWindow(TOOL_WINDOW_ID);
                if (window != null && window.isVisible() && (console = logcatView.getLogConsole().getConsole()) != null) {
                    AndroidToolWindowFactory.checkFacetAndSdk(project, console);
                }
            }
        }, project.getDisposed());
        final File adb = AndroidSdkUtils.getAdb(project);
        if (adb == null) {
            return;
        }
        loadingPanel.setLoadingText("Initializing ADB");
        loadingPanel.startLoading();
        ListenableFuture<AndroidDebugBridge> future = AdbService.getInstance().getDebugBridge(adb);
        Futures.addCallback(future, (FutureCallback)new FutureCallback<AndroidDebugBridge>(){

            public void onSuccess(AndroidDebugBridge bridge) {
                Logger.getInstance(AndroidToolWindowFactory.class).info("Successfully obtained debug bridge");
                loadingPanel.stopLoading();
            }

            public void onFailure(Throwable t) {
                loadingPanel.stopLoading();
                Logger.getInstance(AndroidToolWindowFactory.class).info("Unable to obtain debug bridge", t);
                String msg = t.getMessage() != null ? t.getMessage() : String.format("Unable to establish a connection to adb.\n\nCheck the Event Log for possible issues.\nThis can happen if you have an incompatible version of adb running already.\nTry re-opening Studio after killing any existing adb daemons.\n\nIf this happens repeatedly, please file a bug at http://b.android.com including the following:\n  1. Output of the command: '%1$s devices'\n  2. Your idea.log file (Help | Show Log in Explorer)\n", adb.getAbsolutePath());
                Messages.showErrorDialog((String)msg, (String)"ADB Connection Error");
            }
        }, (Executor)EdtExecutor.INSTANCE);
    }

    private static ViewContent createMemoryViewContent(RunnerLayoutUi layoutUi, Project project, DeviceContext deviceContext) {
        MemoryMonitorView view = new MemoryMonitorView(project, deviceContext);
        Content content = layoutUi.createContent("Memory", view.createComponent(), "Memory", AndroidIcons.MemoryMonitor, null);
        content.setCloseable(false);
        return new ViewContent(view, content);
    }

    private static ViewContent createCpuViewContent(RunnerLayoutUi layoutUi, Project project, DeviceContext deviceContext) {
        CpuMonitorView view = new CpuMonitorView(project, deviceContext);
        Content content = layoutUi.createContent("CPU", view.createComponent(), "CPU", AndroidIcons.CpuMonitor, null);
        content.setCloseable(false);
        return new ViewContent(view, content);
    }

    private static ViewContent createGpuViewContent(RunnerLayoutUi layoutUi, Project project, DeviceContext deviceContext) {
        GpuMonitorView view = new GpuMonitorView(project, deviceContext);
        Content content = layoutUi.createContent("GPU", view.createComponent(), "GPU", AndroidIcons.GpuMonitor, null);
        content.setCloseable(false);
        return new ViewContent(view, content);
    }

    private static ViewContent createNetworkViewContent(RunnerLayoutUi layoutUi, Project project, DeviceContext deviceContext) {
        NetworkMonitorView view = new NetworkMonitorView(project, deviceContext);
        Content content = layoutUi.createContent("Network", view.createComponent(), "Network", AndroidIcons.NetworkMonitor, null);
        content.setCloseable(false);
        return new ViewContent(view, content);
    }

    public ActionGroup getToolbarActions(Project project, DeviceContext deviceContext) {
        DefaultActionGroup group = new DefaultActionGroup();
        group.add((AnAction)new ScreenshotAction(project, deviceContext));
        group.add((AnAction)new ScreenRecorderAction(project, deviceContext));
        group.add((AnAction)DumpSysActions.create(project, deviceContext));
        group.add((AnAction)new Separator());
        group.add((AnAction)new TerminateVMAction(deviceContext));
        return group;
    }

    private static Content createLogcatContent(RunnerLayoutUi layoutUi, final Project project, DeviceContext deviceContext) {
        final AndroidLogcatView logcatView = new AndroidLogcatView(project, deviceContext){

            @Override
            protected boolean isActive() {
                ToolWindow window = ToolWindowManager.getInstance((Project)project).getToolWindow(TOOL_WINDOW_ID);
                return window.isVisible();
            }
        };
        ToolWindowManagerEx.getInstanceEx((Project)project).addToolWindowManagerListener((ToolWindowManagerListener)new ToolWindowManagerAdapter(){
            boolean myToolWindowVisible;

            public void stateChanged() {
                boolean visible;
                ToolWindow window = ToolWindowManager.getInstance((Project)project).getToolWindow(TOOL_WINDOW_ID);
                if (window != null && (visible = window.isVisible()) != this.myToolWindowVisible) {
                    ConsoleView console;
                    this.myToolWindowVisible = visible;
                    logcatView.activate();
                    if (visible && (console = logcatView.getLogConsole().getConsole()) != null) {
                        AndroidToolWindowFactory.checkFacetAndSdk(project, console);
                    }
                }
            }
        });
        MessageBusConnection connection = project.getMessageBus().connect((Disposable)project);
        connection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new MyAndroidPlatformListener(logcatView));
        JPanel logcatContentPanel = logcatView.getContentPanel();
        Content logcatContent = layoutUi.createContent("Android Logcat", (JComponent)logcatContentPanel, "logcat", AndroidIcons.Ddms.Logcat, null);
        logcatContent.putUserData(AndroidLogcatView.ANDROID_LOGCAT_VIEW_KEY, (Object)logcatView);
        logcatContent.setDisposer((Disposable)logcatView);
        logcatContent.setCloseable(false);
        logcatContent.setPreferredFocusableComponent((JComponent)logcatContentPanel);
        return logcatContent;
    }

    private static void checkFacetAndSdk(Project project, ConsoleView console) {
        List facets = ProjectFacetManager.getInstance((Project)project).getFacets(AndroidFacet.ID);
        if (facets.size() == 0) {
            console.clear();
            console.print(AndroidBundle.message("android.logcat.no.android.facets.error", new Object[0]), ConsoleViewContentType.ERROR_OUTPUT);
            return;
        }
        AndroidFacet facet = (AndroidFacet)((Object)facets.get(0));
        AndroidPlatform platform = ((AndroidFacetConfiguration)facet.getConfiguration()).getAndroidPlatform();
        if (platform == null) {
            console.clear();
            final Module module = facet.getModule();
            if (!AndroidMavenUtil.isMavenizedModule(module)) {
                console.print("Please ", ConsoleViewContentType.ERROR_OUTPUT);
                console.printHyperlink("configure", new HyperlinkInfo(){

                    public void navigate(Project project) {
                        AndroidSdkUtils.openModuleDependenciesConfigurable(module);
                    }
                });
                console.print(" Android SDK\n", ConsoleViewContentType.ERROR_OUTPUT);
            } else {
                console.print(AndroidBundle.message("android.maven.cannot.parse.android.sdk.error", module.getName()) + '\n', ConsoleViewContentType.ERROR_OUTPUT);
            }
        }
    }

    private static class ViewContent {
        private BaseMonitorView<? extends DeviceSampler> myView;
        private Content myContent;

        private ViewContent(BaseMonitorView<? extends DeviceSampler> view, Content content) {
            this.myView = view;
            this.myContent = content;
        }
    }

    private static class MyAndroidPlatformListener
    extends ModuleRootAdapter {
        private final Project myProject;
        private final AndroidLogcatView myView;
        private AndroidPlatform myPrevPlatform;

        private MyAndroidPlatformListener(AndroidLogcatView view) {
            this.myProject = view.getProject();
            this.myView = view;
            this.myPrevPlatform = this.getPlatform();
        }

        public void rootsChanged(ModuleRootEvent event) {
            final ToolWindow window = ToolWindowManager.getInstance((Project)this.myProject).getToolWindow(TOOL_WINDOW_ID);
            if (window == null) {
                return;
            }
            if (window.isDisposed() || !window.isVisible()) {
                return;
            }
            AndroidPlatform newPlatform = this.getPlatform();
            if (!Comparing.equal((Object)this.myPrevPlatform, (Object)newPlatform)) {
                this.myPrevPlatform = newPlatform;
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (!window.isDisposed() && window.isVisible()) {
                            MyAndroidPlatformListener.this.myView.activate();
                        }
                    }
                });
            }
        }

        private AndroidPlatform getPlatform() {
            AndroidPlatform newPlatform = null;
            List facets = ProjectFacetManager.getInstance((Project)this.myProject).getFacets(AndroidFacet.ID);
            if (facets.size() > 0) {
                AndroidFacet facet = (AndroidFacet)((Object)facets.get(0));
                newPlatform = ((AndroidFacetConfiguration)facet.getConfiguration()).getAndroidPlatform();
            }
            return newPlatform;
        }
    }
}

