/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.model;

import com.android.ide.common.rendering.HardwareConfigHelper;
import com.android.resources.ScreenSize;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.SdkVersionInfo;
import com.android.sdklib.devices.Device;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.model.ManifestInfo;
import com.android.tools.idea.rendering.multi.CompatibilityRenderTarget;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.android.util.AndroidUtils;

class PrimaryManifestInfo
extends ManifestInfo {
    private static final Logger LOG = Logger.getInstance(PrimaryManifestInfo.class);
    private final Module myModule;
    private String myPackage;
    private String myManifestTheme;
    private Map<String, ManifestInfo.ActivityAttributes> myActivityAttributesMap;
    private ManifestFile myManifestFile;
    private long myLastChecked;
    private AndroidVersion myMinSdk;
    private AndroidVersion myTargetSdk;
    private String myApplicationIcon;
    private String myApplicationLabel;
    private boolean myApplicationSupportsRtl;
    private Manifest myManifest;
    private Boolean myApplicationDebuggable;

    PrimaryManifestInfo(Module module) {
        this.myModule = module;
    }

    @Override
    public void clear() {
        this.myLastChecked = 0L;
    }

    @Override
    public String getPackage() {
        this.sync();
        return this.myPackage;
    }

    @Override
    public Map<String, ManifestInfo.ActivityAttributes> getActivityAttributesMap() {
        this.sync();
        if (this.myActivityAttributesMap == null) {
            return Collections.emptyMap();
        }
        return this.myActivityAttributesMap;
    }

    @Override
    public ManifestInfo.ActivityAttributes getActivityAttributes(String activity) {
        int index = activity.indexOf(46);
        if (index <= 0 && this.myPackage != null && !this.myPackage.isEmpty()) {
            activity = this.myPackage + (index == -1 ? "." : "") + activity;
        }
        return this.getActivityAttributesMap().get(activity);
    }

    @Override
    public String getManifestTheme() {
        this.sync();
        return this.myManifestTheme;
    }

    @Override
    public String getDefaultTheme(IAndroidTarget renderingTarget, ScreenSize screenSize, Device device) {
        AndroidModuleInfo info;
        this.sync();
        if (this.myManifestTheme != null) {
            return this.myManifestTheme;
        }
        if (device != null) {
            if (HardwareConfigHelper.isWear((Device)device)) {
                return "@android:style/Theme.DeviceDefault.Light";
            }
            if (HardwareConfigHelper.isTv((Device)device)) {
                return "@style/Theme.Leanback";
            }
        }
        int targetSdk = (info = AndroidModuleInfo.get(this.myModule)) != null ? info.getTargetSdkVersion().getApiLevel() : (this.myTargetSdk != null ? this.myTargetSdk.getApiLevel() : 23);
        int renderingTargetSdk = targetSdk;
        if (renderingTarget instanceof CompatibilityRenderTarget) {
            renderingTargetSdk = renderingTarget.getVersion().getApiLevel();
        } else if (renderingTarget != null) {
            renderingTargetSdk = renderingTarget.getVersion().getApiLevel();
        }
        int apiLevel = Math.min(targetSdk, renderingTargetSdk);
        if (apiLevel >= 21) {
            return "@android:style/Theme.Material.Light";
        }
        if (apiLevel >= 14 || apiLevel >= 11 && screenSize == ScreenSize.XLARGE) {
            return "@android:style/Theme.Holo";
        }
        return "@android:style/Theme";
    }

    @Override
    public String getApplicationIcon() {
        this.sync();
        return this.myApplicationIcon;
    }

    @Override
    public String getApplicationLabel() {
        this.sync();
        return this.myApplicationLabel;
    }

    @Override
    public boolean isRtlSupported() {
        this.sync();
        return this.myApplicationSupportsRtl;
    }

    @Override
    public Boolean getApplicationDebuggable() {
        this.sync();
        return this.myApplicationDebuggable;
    }

    @Override
    public AndroidVersion getTargetSdkVersion() {
        this.sync();
        return this.myTargetSdk != null ? this.myTargetSdk : this.getMinSdkVersion();
    }

    @Override
    public AndroidVersion getMinSdkVersion() {
        this.sync();
        return this.myMinSdk != null ? this.myMinSdk : AndroidVersion.DEFAULT;
    }

    @Override
    protected List<Manifest> getManifests() {
        this.sync();
        return this.myManifest != null ? Collections.singletonList(this.myManifest) : Collections.emptyList();
    }

    private void sync() {
        long now = System.currentTimeMillis();
        if (now - this.myLastChecked < 50L && this.myManifestFile != null) {
            return;
        }
        this.myLastChecked = now;
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                PrimaryManifestInfo.this.syncWithReadPermission();
            }
        });
    }

    private void syncWithReadPermission() {
        boolean refresh;
        if (this.myManifestFile == null) {
            this.myManifestFile = ManifestFile.create(this.myModule);
            if (this.myManifestFile == null) {
                return;
            }
        }
        if (!(refresh = this.myManifestFile.refresh())) {
            return;
        }
        this.myActivityAttributesMap = new HashMap<String, ManifestInfo.ActivityAttributes>();
        this.myManifestTheme = null;
        this.myTargetSdk = AndroidVersion.DEFAULT;
        this.myMinSdk = AndroidVersion.DEFAULT;
        this.myPackage = "";
        this.myApplicationIcon = null;
        this.myApplicationLabel = null;
        this.myApplicationSupportsRtl = false;
        try {
            XmlTag[] usesSdks;
            XmlFile xmlFile = this.myManifestFile.getXmlFile();
            if (xmlFile == null) {
                return;
            }
            XmlTag root = xmlFile.getRootTag();
            if (root == null) {
                return;
            }
            this.myPackage = root.getAttributeValue("package");
            XmlTag[] applications = root.findSubTags("application");
            if (applications.length > 0) {
                XmlTag[] activities;
                assert (applications.length == 1);
                XmlTag application = applications[0];
                this.myApplicationIcon = application.getAttributeValue("icon", "http://schemas.android.com/apk/res/android");
                this.myApplicationLabel = application.getAttributeValue("label", "http://schemas.android.com/apk/res/android");
                this.myManifestTheme = application.getAttributeValue("theme", "http://schemas.android.com/apk/res/android");
                this.myApplicationSupportsRtl = "true".equals(application.getAttributeValue("supportsRtl", "http://schemas.android.com/apk/res/android"));
                String debuggable = application.getAttributeValue("debuggable", "http://schemas.android.com/apk/res/android");
                this.myApplicationDebuggable = debuggable == null ? null : Boolean.valueOf("true".equals(debuggable));
                for (XmlTag activity : activities = application.findSubTags("activity")) {
                    ManifestInfo.ActivityAttributes attributes = new ManifestInfo.ActivityAttributes(activity, this.myPackage);
                    this.myActivityAttributesMap.put(attributes.getName(), attributes);
                }
            }
            if ((usesSdks = root.findSubTags("uses-sdk")).length > 0) {
                XmlTag usesSdk = usesSdks[0];
                this.myMinSdk = PrimaryManifestInfo.getApiVersion(usesSdk, "minSdkVersion", AndroidVersion.DEFAULT);
                this.myTargetSdk = PrimaryManifestInfo.getApiVersion(usesSdk, "targetSdkVersion", this.myMinSdk);
            }
            this.myManifest = AndroidUtils.loadDomElementWithReadPermission(this.myModule.getProject(), xmlFile, Manifest.class);
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error("Could not read Manifest data", (Throwable)e);
        }
    }

    private static AndroidVersion getApiVersion(XmlTag usesSdk, String attribute, AndroidVersion defaultApiLevel) {
        AndroidVersion version;
        String valueString = usesSdk.getAttributeValue(attribute, "http://schemas.android.com/apk/res/android");
        if (valueString != null && (version = SdkVersionInfo.getVersion((String)valueString, null)) != null) {
            return version;
        }
        return defaultApiLevel;
    }

    private static class ManifestFile {
        private final Module myModule;
        private VirtualFile myVFile;
        private XmlFile myXmlFile;
        private long myLastModified = 0L;

        private ManifestFile(Module module, VirtualFile file) {
            this.myModule = module;
            this.myVFile = file;
        }

        public static synchronized ManifestFile create(Module module) {
            ApplicationManager.getApplication().assertReadAccessAllowed();
            AndroidFacet facet = AndroidFacet.getInstance(module);
            if (facet == null) {
                return null;
            }
            VirtualFile manifestFile = AndroidRootUtil.getPrimaryManifestFile(facet);
            if (manifestFile == null) {
                return null;
            }
            return new ManifestFile(module, manifestFile);
        }

        private XmlFile parseManifest() {
            if (this.myVFile == null || !this.myVFile.exists()) {
                return null;
            }
            Project project = this.myModule.getProject();
            if (project.isDisposed()) {
                return null;
            }
            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(this.myVFile);
            return psiFile instanceof XmlFile ? (XmlFile)psiFile : null;
        }

        public synchronized boolean refresh() {
            long lastModified = this.getLastModified();
            if (this.myXmlFile == null || this.myLastModified < lastModified) {
                this.myXmlFile = this.parseManifest();
                if (this.myXmlFile == null) {
                    return false;
                }
                this.myLastModified = lastModified;
                return true;
            }
            return false;
        }

        private long getLastModified() {
            if (this.myXmlFile != null) {
                return this.myXmlFile.getModificationStamp();
            }
            return 0L;
        }

        public synchronized XmlFile getXmlFile() {
            return this.myXmlFile;
        }
    }
}

