/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.model;

import com.android.resources.ScreenSize;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.devices.Device;
import com.android.tools.idea.model.MergedManifestInfo;
import com.android.tools.idea.model.PrimaryManifestInfo;
import com.google.common.collect.Lists;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Function;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.android.dom.manifest.Activity;
import org.jetbrains.android.dom.manifest.ActivityAlias;
import org.jetbrains.android.dom.manifest.Application;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.dom.manifest.Service;
import org.jetbrains.android.dom.manifest.UsesFeature;
import org.jetbrains.android.facet.AndroidFacet;

public abstract class ManifestInfo {
    static final Key<ManifestInfo> MANIFEST_FINDER = new Key("adt-manifest-info");
    static final Key<ManifestInfo> MERGED_MANIFEST_FINDER = new Key("adt-merged-manifest-info");

    public static ManifestInfo get(Module module) {
        return ManifestInfo.get(module, false);
    }

    public static ManifestInfo get(Module module, boolean useMergedManifest) {
        Key<ManifestInfo> key = useMergedManifest ? MERGED_MANIFEST_FINDER : MANIFEST_FINDER;
        ManifestInfo finder = (ManifestInfo)module.getUserData(key);
        if (finder == null) {
            AndroidFacet facet = AndroidFacet.getInstance(module);
            if (facet == null) {
                throw new IllegalArgumentException("Manifest information can only be obtained on modules with the Android facet.");
            }
            finder = useMergedManifest ? new MergedManifestInfo(module) : new PrimaryManifestInfo(module);
            module.putUserData(key, (Object)finder);
        }
        return finder;
    }

    public abstract void clear();

    public abstract String getPackage();

    public abstract Map<String, ActivityAttributes> getActivityAttributesMap();

    public abstract ActivityAttributes getActivityAttributes(String var1);

    public abstract String getManifestTheme();

    public abstract String getDefaultTheme(IAndroidTarget var1, ScreenSize var2, Device var3);

    public abstract String getApplicationIcon();

    public abstract String getApplicationLabel();

    public abstract boolean isRtlSupported();

    public abstract Boolean getApplicationDebuggable();

    public abstract AndroidVersion getTargetSdkVersion();

    public abstract AndroidVersion getMinSdkVersion();

    public List<Activity> getActivities() {
        return this.getApplicationComponents(new Function<Application, List<Activity>>(){

            public List<Activity> fun(Application application) {
                return application.getActivities();
            }
        });
    }

    public List<ActivityAlias> getActivityAliases() {
        return this.getApplicationComponents(new Function<Application, List<ActivityAlias>>(){

            public List<ActivityAlias> fun(Application application) {
                return application.getActivityAliass();
            }
        });
    }

    public List<Service> getServices() {
        return this.getApplicationComponents(new Function<Application, List<Service>>(){

            public List<Service> fun(Application application) {
                return application.getServices();
            }
        });
    }

    private <T> List<T> getApplicationComponents(final Function<Application, List<T>> accessor) {
        final List<Manifest> manifests = this.getManifests();
        if (manifests.isEmpty()) {
            Logger.getInstance(ManifestInfo.class).warn("List of manifests is empty, possibly needs a gradle sync.");
        }
        return (List)ApplicationManager.getApplication().runReadAction(new Computable<List<T>>(){

            public List<T> compute() {
                ArrayList components = Lists.newArrayList();
                for (Manifest m : manifests) {
                    Application application = m.getApplication();
                    if (application == null) continue;
                    components.addAll((Collection)accessor.fun((Object)application));
                }
                return components;
            }
        });
    }

    public List<UsesFeature> getUsedFeatures() {
        final List<Manifest> manifests = this.getManifests();
        if (manifests.isEmpty()) {
            Logger.getInstance(ManifestInfo.class).warn("List of manifests is empty, possibly needs a gradle sync.");
        }
        return (List)ApplicationManager.getApplication().runReadAction((Computable)new Computable<List<UsesFeature>>(){

            public List<UsesFeature> compute() {
                ArrayList usesFeatures = Lists.newArrayList();
                for (Manifest m : manifests) {
                    usesFeatures.addAll(m.getUsesFeatures());
                }
                return usesFeatures;
            }
        });
    }

    protected abstract List<Manifest> getManifests();

    public static class ActivityAttributes {
        private final String myIcon;
        private final String myLabel;
        private final String myName;
        private final String myParentActivity;
        private final String myTheme;
        private final String myUiOptions;

        public ActivityAttributes(XmlTag activity, String packageName) {
            String name = activity.getAttributeValue("name", "http://schemas.android.com/apk/res/android");
            if (name == null || name.length() == 0) {
                throw new RuntimeException("Activity name cannot be empty.");
            }
            int index = name.indexOf(46);
            if (index <= 0 && packageName != null && !packageName.isEmpty()) {
                name = packageName + (index == -1 ? "." : "") + name;
            }
            this.myName = name;
            String value = activity.getAttributeValue("icon", "http://schemas.android.com/apk/res/android");
            this.myIcon = value != null && value.length() > 0 ? value : null;
            value = activity.getAttributeValue("label", "http://schemas.android.com/apk/res/android");
            this.myLabel = value != null && value.length() > 0 ? value : null;
            value = activity.getAttributeValue("parentActivityName", "http://schemas.android.com/apk/res/android");
            if (value == null || value.length() == 0) {
                XmlTag[] metaData;
                for (XmlTag data : metaData = activity.findSubTags("meta-data")) {
                    String metaDataName = data.getAttributeValue("name", "http://schemas.android.com/apk/res/android");
                    if (!"android.support.PARENT_ACTIVITY".equals(metaDataName) || (value = data.getAttributeValue("value", "http://schemas.android.com/apk/res/android")) == null || (index = value.indexOf(46)) > 0 || packageName == null || packageName.isEmpty()) continue;
                    value = packageName + (index == -1 ? "." : "") + value;
                    break;
                }
            }
            this.myParentActivity = value != null && value.length() > 0 ? value : null;
            value = activity.getAttributeValue("theme", "http://schemas.android.com/apk/res/android");
            this.myTheme = value != null && value.length() > 0 ? value : null;
            value = activity.getAttributeValue("uiOptions", "http://schemas.android.com/apk/res/android");
            this.myUiOptions = value != null && value.length() > 0 ? value : null;
        }

        public String getIcon() {
            return this.myIcon;
        }

        public String getLabel() {
            return this.myLabel;
        }

        public String getName() {
            return this.myName;
        }

        public String getParentActivity() {
            return this.myParentActivity;
        }

        public String getTheme() {
            return this.myTheme;
        }

        public String getUiOptions() {
            return this.myUiOptions;
        }
    }
}

