/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.model;

import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.model.AndroidModel;
import com.android.tools.idea.model.ManifestInfo;
import com.intellij.openapi.module.Module;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.AndroidPlatform;

public class AndroidModuleInfo {
    private final AndroidFacet myFacet;

    private AndroidModuleInfo(AndroidFacet facet) {
        this.myFacet = facet;
    }

    public static AndroidModuleInfo create(AndroidFacet facet) {
        return new AndroidModuleInfo(facet);
    }

    public static AndroidModuleInfo get(AndroidFacet facet) {
        return facet.getAndroidModuleInfo();
    }

    public static AndroidModuleInfo get(Module module) {
        AndroidFacet facet = AndroidFacet.getInstance(module);
        return facet != null ? facet.getAndroidModuleInfo() : null;
    }

    public String getPackage() {
        AndroidModel androidModel = this.myFacet.getAndroidModel();
        if (androidModel != null) {
            return androidModel.getApplicationId();
        }
        return ManifestInfo.get(this.myFacet.getModule(), false).getPackage();
    }

    public AndroidVersion getRuntimeMinSdkVersion() {
        AndroidVersion minSdkVersion;
        AndroidModel androidModel = this.myFacet.getAndroidModel();
        if (androidModel != null && (minSdkVersion = androidModel.getRuntimeMinSdkVersion()) != null) {
            return minSdkVersion;
        }
        return ManifestInfo.get(this.myFacet.getModule(), false).getMinSdkVersion();
    }

    public AndroidVersion getMinSdkVersion() {
        AndroidVersion minSdkVersion;
        AndroidModel androidModel = this.myFacet.getAndroidModel();
        if (androidModel != null && (minSdkVersion = androidModel.getMinSdkVersion()) != null) {
            return minSdkVersion;
        }
        return ManifestInfo.get(this.myFacet.getModule(), false).getMinSdkVersion();
    }

    public AndroidVersion getTargetSdkVersion() {
        AndroidVersion targetSdkVersion;
        AndroidModel androidModel = this.myFacet.getAndroidModel();
        if (androidModel != null && (targetSdkVersion = androidModel.getTargetSdkVersion()) != null) {
            return targetSdkVersion;
        }
        return ManifestInfo.get(this.myFacet.getModule(), false).getTargetSdkVersion();
    }

    public AndroidVersion getBuildSdkVersion() {
        AndroidPlatform platform = AndroidPlatform.getInstance(this.myFacet.getModule());
        if (platform != null) {
            return platform.getApiVersion();
        }
        return null;
    }

    public Boolean isDebuggable() {
        Boolean debuggable;
        AndroidModel androidModel = this.myFacet.getAndroidModel();
        if (androidModel != null && (debuggable = androidModel.isDebuggable()) != null) {
            return debuggable;
        }
        return ManifestInfo.get(this.myFacet.getModule(), false).getApplicationDebuggable();
    }

    public static AndroidVersion getBuildSdkVersion(Module module) {
        AndroidModuleInfo moduleInfo;
        AndroidFacet facet;
        if (module != null && (facet = AndroidFacet.getInstance(module)) != null && (moduleInfo = AndroidModuleInfo.get(facet.getModule())) != null) {
            return moduleInfo.getBuildSdkVersion();
        }
        return null;
    }

    public static int getBuildSdkApiLevel(Module module) {
        AndroidVersion version = AndroidModuleInfo.getBuildSdkVersion(module);
        return version != null ? version.getApiLevel() : -1;
    }

    public static AndroidVersion getTargetSdkVersion(Module module) {
        AndroidModuleInfo moduleInfo;
        AndroidFacet facet;
        if (module != null && (facet = AndroidFacet.getInstance(module)) != null && (moduleInfo = AndroidModuleInfo.get(facet.getModule())) != null) {
            return moduleInfo.getTargetSdkVersion();
        }
        return AndroidVersion.DEFAULT;
    }

    public static AndroidVersion getMinSdkVersion(Module module) {
        AndroidModuleInfo moduleInfo;
        AndroidFacet facet;
        if (module != null && (facet = AndroidFacet.getInstance(module)) != null && (moduleInfo = AndroidModuleInfo.get(facet.getModule())) != null) {
            return moduleInfo.getMinSdkVersion();
        }
        return AndroidVersion.DEFAULT;
    }
}

