/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.logcat;

import com.android.ddmlib.Log;
import com.android.ddmlib.logcat.LogCatHeader;
import com.android.ddmlib.logcat.LogCatTimestamp;
import com.android.tools.idea.logcat.AndroidLogcatFormatter;
import com.android.tools.idea.logcat.AndroidLogcatPreferences;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import org.jetbrains.android.util.AndroidBundle;

public class ConfigureLogcatFormatDialog
extends DialogWrapper {
    private static final String SAMPLE_OUTPUT;
    private final AndroidLogcatPreferences myPreferences;
    private JPanel topPanel;
    private JCheckBox myShowTimeCheckBox;
    private JCheckBox myShowPidTidCheckBox;
    private JCheckBox myShowPackageNameCheckBox;
    private JCheckBox myShowTag;
    private JLabel myDemoLabel;
    private String myFormatString;

    public ConfigureLogcatFormatDialog(Project project) {
        super(project, false, DialogWrapper.IdeModalityType.PROJECT);
        this.$$$setupUI$$$();
        this.init();
        this.setTitle(AndroidBundle.message("android.configure.logcat.header.title", new Object[0]));
        this.myPreferences = AndroidLogcatPreferences.getInstance(project);
        this.myFormatString = this.myPreferences.LOGCAT_FORMAT_STRING;
        this.myShowTimeCheckBox.setSelected(this.myFormatString.isEmpty() || this.myFormatString.contains("%1$s"));
        this.myShowPidTidCheckBox.setSelected(this.myFormatString.isEmpty() || this.myFormatString.contains("%2$s"));
        this.myShowPackageNameCheckBox.setSelected(this.myFormatString.isEmpty() || this.myFormatString.contains("%3$s"));
        this.myShowTag.setSelected(this.myFormatString.isEmpty() || this.myFormatString.contains("%5$s"));
        ItemListener checkboxListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ConfigureLogcatFormatDialog.this.rebuildFormatString();
            }
        };
        this.myShowTimeCheckBox.addItemListener(checkboxListener);
        this.myShowPidTidCheckBox.addItemListener(checkboxListener);
        this.myShowPackageNameCheckBox.addItemListener(checkboxListener);
        this.myShowTag.addItemListener(checkboxListener);
        this.updateDemoLabel();
    }

    private void rebuildFormatString() {
        this.myFormatString = this.myShowTimeCheckBox.isSelected() && this.myShowPidTidCheckBox.isSelected() && this.myShowPackageNameCheckBox.isSelected() && this.myShowTag.isSelected() ? "" : AndroidLogcatFormatter.createCustomFormat(this.myShowTimeCheckBox.isSelected(), this.myShowPidTidCheckBox.isSelected(), this.myShowPackageNameCheckBox.isSelected(), this.myShowTag.isSelected());
        this.updateDemoLabel();
    }

    private void updateDemoLabel() {
        this.myDemoLabel.setText(AndroidLogcatFormatter.formatMessage(this.myFormatString, SAMPLE_OUTPUT));
    }

    protected JComponent createCenterPanel() {
        return this.topPanel;
    }

    protected void doOKAction() {
        this.myPreferences.LOGCAT_FORMAT_STRING = this.myFormatString;
        super.doOKAction();
    }

    static {
        LogCatHeader sampleHeader = new LogCatHeader(Log.LogLevel.INFO, 123, 456, "com.android.sample", "SampleTag", LogCatTimestamp.fromString((String)"01-23 12:34:56.789"));
        SAMPLE_OUTPUT = AndroidLogcatFormatter.formatMessageFull(sampleHeader, "This is a sample message");
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JLabel jLabel;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JCheckBox jCheckBox4;
        JPanel jPanel;
        this.topPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(6, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myShowTimeCheckBox = jCheckBox4 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox4, ResourceBundle.getBundle("messages/AndroidBundle").getString("android.logcat.header.dialog.show.time"));
        jPanel.add((Component)jCheckBox4, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myShowPidTidCheckBox = jCheckBox3 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox3, ResourceBundle.getBundle("messages/AndroidBundle").getString("android.logcat.header.dialog.show.process.info"));
        jPanel.add((Component)jCheckBox3, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myShowPackageNameCheckBox = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("messages/AndroidBundle").getString("android.logcat.header.dialog.show.packageName"));
        jPanel.add((Component)jCheckBox2, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myDemoLabel = jLabel = new JLabel();
        Font font = jLabel.getFont();
        jLabel.setFont(new Font("Courier New", font.getStyle(), font.getSize()));
        jLabel.setText("Label");
        jPanel.add((Component)jLabel, new GridConstraints(5, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myShowTag = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messages/AndroidBundle").getString("android.logcat.header.dialog.show.tag"));
        jPanel.add((Component)jCheckBox, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JToolBar.Separator separator = new JToolBar.Separator();
        jPanel.add((Component)separator, new GridConstraints(4, 0, 1, 1, 0, 1, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.topPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

