/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.logcat;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.Log;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.TimeoutException;
import com.android.tools.idea.logcat.AndroidConsoleWriter;
import com.android.tools.idea.logcat.AndroidLogcatFormatter;
import com.android.tools.idea.logcat.AndroidLogcatReceiver;
import com.android.tools.idea.run.LoggingReceiver;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ui.UIUtil;
import java.io.IOException;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidOutputReceiver;
import org.jetbrains.android.util.AndroidUtils;

public final class AndroidLogcatUtils {
    private static final Logger LOG = Logger.getInstance(AndroidLogcatUtils.class);

    private AndroidLogcatUtils() {
    }

    private static void startLogging(IDevice device, AndroidOutputReceiver receiver) throws IOException, ShellCommandUnresponsiveException, AdbCommandRejectedException, TimeoutException {
        AndroidUtils.executeCommandOnDevice(device, "logcat -v long", receiver, true);
    }

    static void clearLogcat(final Project project, IDevice device) {
        try {
            AndroidUtils.executeCommandOnDevice(device, "logcat -c", new LoggingReceiver(LOG), false);
        }
        catch (Exception e) {
            LOG.info((Throwable)e);
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    Messages.showErrorDialog((Project)project, (String)("Error: " + e.getMessage()), (String)AndroidBundle.message("android.logcat.error.dialog.title", new Object[0]));
                }
            });
        }
    }

    public static AndroidLogcatReceiver startLoggingThread(final Project project, final IDevice device, final boolean clearLogcat, final AndroidConsoleWriter writer) {
        UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                writer.clear();
            }
        });
        final AndroidLogcatReceiver receiver = new AndroidLogcatReceiver(device, writer);
        Disposer.register((Disposable)project, (Disposable)receiver);
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                if (clearLogcat) {
                    AndroidLogcatUtils.clearLogcat(project, device);
                }
                try {
                    AndroidLogcatUtils.startLogging(device, receiver);
                }
                catch (Exception e) {
                    LOG.info((Throwable)e);
                    writer.addMessage(AndroidLogcatFormatter.formatMessage(Log.LogLevel.ERROR, e.getMessage()));
                }
            }
        });
        return receiver;
    }
}

