/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.logcat;

import com.android.ddmlib.IDevice;
import com.android.ddmlib.logcat.LogCatHeader;
import com.android.ddmlib.logcat.LogCatMessageParser;
import com.android.tools.idea.logcat.AndroidConsoleWriter;
import com.android.tools.idea.logcat.AndroidLogcatFormatter;
import com.android.tools.idea.logcat.StackTraceExpander;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.android.util.AndroidOutputReceiver;

public final class AndroidLogcatReceiver
extends AndroidOutputReceiver
implements Disposable {
    private final LogCatMessageParser myParser = new LogCatMessageParser();
    private static final String STACK_TRACE_LINE_PREFIX = StringUtil.repeatSymbol((char)' ', (int)4);
    private static final String STACK_TRACE_CAUSE_LINE_PREFIX = Character.toString(' ');
    private volatile boolean myCanceled = false;
    private final AndroidConsoleWriter myWriter;
    private final IDevice myDevice;
    private final StackTraceExpander myStackTraceExpander;
    private LogCatHeader myActiveHeader;
    private int myLineIndex;

    public AndroidLogcatReceiver(IDevice device, AndroidConsoleWriter writer) {
        this.myDevice = device;
        this.myWriter = writer;
        this.myStackTraceExpander = new StackTraceExpander(STACK_TRACE_LINE_PREFIX, STACK_TRACE_CAUSE_LINE_PREFIX);
    }

    @Override
    public void processNewLine(String line) {
        if (line.isEmpty()) {
            this.myStackTraceExpander.reset();
            this.myActiveHeader = null;
            return;
        }
        LogCatHeader header = this.myParser.processLogHeader(line, this.myDevice);
        if (header != null) {
            this.myActiveHeader = header;
            this.myLineIndex = 0;
        } else if (this.myActiveHeader != null) {
            this.myStackTraceExpander.process(line);
            for (String processedLine : this.myStackTraceExpander.getProcessedLines()) {
                processedLine = this.myLineIndex == 0 ? AndroidLogcatFormatter.formatMessageFull(this.myActiveHeader, processedLine) : AndroidLogcatFormatter.formatContinuation(processedLine);
                this.myWriter.addMessage(processedLine);
                ++this.myLineIndex;
            }
        }
    }

    public boolean isCancelled() {
        return this.myCanceled;
    }

    public void dispose() {
        this.cancel();
    }

    public void cancel() {
        this.myCanceled = true;
    }
}

