/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.logcat;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.util.xmlb.XmlSerializerUtil;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import com.intellij.util.xmlb.annotations.Tag;
import java.util.ArrayList;
import java.util.List;

@State(name="AndroidConfiguredLogFilters", storages={@Storage(file="$WORKSPACE_FILE$")})
public final class AndroidConfiguredLogFilters
implements PersistentStateComponent<AndroidConfiguredLogFilters> {
    private List<FilterEntry> myFilterEntries = new ArrayList<FilterEntry>();

    public AndroidConfiguredLogFilters getState() {
        return this;
    }

    public void loadState(AndroidConfiguredLogFilters state) {
        XmlSerializerUtil.copyBean((Object)state, (Object)this);
    }

    public static AndroidConfiguredLogFilters getInstance(Project project) {
        return (AndroidConfiguredLogFilters)ServiceManager.getService((Project)project, AndroidConfiguredLogFilters.class);
    }

    @Tag(value="filters")
    @AbstractCollection(surroundWithTag=false)
    public List<FilterEntry> getFilterEntries() {
        return Lists.newArrayList((Iterable)Lists.transform(this.myFilterEntries, (Function)new Function<FilterEntry, FilterEntry>(){

            public FilterEntry apply(FilterEntry srcEntry) {
                return new FilterEntry(srcEntry);
            }
        }));
    }

    public FilterEntry createFilterForProcess(int pid) {
        FilterEntry entry = new FilterEntry();
        String pidString = Integer.toString(pid);
        entry.setName("Process id: " + pidString);
        entry.setPid(pidString);
        return entry;
    }

    public void setFilterEntries(List<FilterEntry> filterEntries) {
        this.myFilterEntries = filterEntries;
    }

    @Tag(value="filter")
    static final class FilterEntry {
        private String myName;
        private String myLogMessagePattern;
        private boolean myLogMessageIsRegex = true;
        private String myLogLevel;
        private String myLogTagPattern;
        private boolean myLogTagIsRegex = true;
        private String myPid;
        private String myPackageNamePattern;
        private boolean myPackageNameIsRegex = true;

        public FilterEntry() {
        }

        public FilterEntry(FilterEntry otherEntry) {
            this.myName = otherEntry.myName;
            this.myLogMessagePattern = otherEntry.myLogMessagePattern;
            this.myLogMessageIsRegex = otherEntry.myLogMessageIsRegex;
            this.myLogLevel = otherEntry.myLogLevel;
            this.myLogTagPattern = otherEntry.myLogTagPattern;
            this.myLogTagIsRegex = otherEntry.myLogTagIsRegex;
            this.myPid = otherEntry.myPid;
            this.myPackageNamePattern = otherEntry.myPackageNamePattern;
            this.myPackageNameIsRegex = otherEntry.myPackageNameIsRegex;
        }

        public String getName() {
            return this.myName;
        }

        public String getLogMessagePattern() {
            return this.myLogMessagePattern;
        }

        public boolean getLogMessageIsRegex() {
            return this.myLogMessageIsRegex;
        }

        public String getLogLevel() {
            return this.myLogLevel;
        }

        public String getLogTagPattern() {
            return this.myLogTagPattern;
        }

        public boolean getLogTagIsRegex() {
            return this.myLogTagIsRegex;
        }

        public String getPid() {
            return this.myPid;
        }

        public void setName(String name) {
            this.myName = name;
        }

        public void setLogMessagePattern(String logMessagePattern) {
            this.myLogMessagePattern = logMessagePattern;
        }

        public void setLogMessageIsRegex(boolean logMessageIsRegex) {
            this.myLogMessageIsRegex = logMessageIsRegex;
        }

        public void setLogLevel(String logLevel) {
            this.myLogLevel = logLevel;
        }

        public void setLogTagPattern(String logTagPattern) {
            this.myLogTagPattern = logTagPattern;
        }

        public void setLogTagIsRegex(boolean logTagIsRegex) {
            this.myLogTagIsRegex = logTagIsRegex;
        }

        public void setPid(String pid) {
            this.myPid = pid;
        }

        public String getPackageNamePattern() {
            return this.myPackageNamePattern;
        }

        public boolean getPackageNameIsRegex() {
            return this.myPackageNameIsRegex;
        }

        public void setPackageNamePattern(String packageNamePattern) {
            this.myPackageNamePattern = packageNamePattern;
        }

        public void setPackageNameIsRegex(boolean logPackageNameIsRegex) {
            this.myPackageNameIsRegex = logPackageNameIsRegex;
        }
    }
}

