/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.util;

import com.google.common.base.Charsets;
import com.google.common.io.Closeables;
import com.intellij.openapi.util.io.FileUtilRt;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;

public final class PropertiesUtil {
    private PropertiesUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getProperties(File filePath) throws IOException {
        if (filePath.isDirectory()) {
            throw new IllegalArgumentException(String.format("The path '%1$s' belongs to a directory!", filePath.getPath()));
        }
        if (!filePath.exists()) {
            return new Properties();
        }
        Properties properties = new Properties();
        InputStreamReader reader = null;
        try {
            reader = new InputStreamReader((InputStream)new BufferedInputStream(new FileInputStream(filePath)), Charsets.UTF_8);
            properties.load(reader);
        }
        catch (Throwable throwable) {
            Closeables.close(reader, (boolean)true);
            throw throwable;
        }
        Closeables.close((Closeable)reader, (boolean)true);
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void savePropertiesToFile(Properties properties, File filePath, String comments) throws IOException {
        FileUtilRt.createParentDirs((File)filePath);
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(filePath);
            properties.store(out, comments);
        }
        finally {
            Closeables.close((Closeable)out, (boolean)true);
        }
    }
}

