/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.util;

import com.android.builder.model.AndroidProject;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.module.Module;
import java.text.Collator;
import java.util.Comparator;

public class ModuleTypeComparator
implements Comparator<Module> {
    public static final ModuleTypeComparator INSTANCE = new ModuleTypeComparator();

    @Override
    public int compare(Module m1, Module m2) {
        AndroidProject p1 = GradleUtil.getAndroidProject(m1);
        AndroidProject p2 = GradleUtil.getAndroidProject(m2);
        return ModuleTypeComparator.compareModules(m1, m2, p1, p2);
    }

    @VisibleForTesting
    static int compareModules(Module m1, Module m2, AndroidProject p1, AndroidProject p2) {
        if (p1 == null && p2 == null || p1 != null && p2 != null && p1.isLibrary() == p2.isLibrary()) {
            return Collator.getInstance().compare(m1.getName(), m2.getName());
        }
        if (p1 != null) {
            if (p2 != null) {
                return !p1.isLibrary() ? -1 : 1;
            }
            return -1;
        }
        return 1;
    }
}

