/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.services;

import com.android.ide.common.repository.GradleCoordinate;
import com.android.tools.idea.gradle.parser.BuildFileKey;
import com.android.tools.idea.gradle.parser.BuildFileStatement;
import com.android.tools.idea.gradle.parser.Dependency;
import com.android.tools.idea.gradle.parser.GradleBuildFile;
import com.android.tools.idea.gradle.project.GradleProjectImporter;
import com.android.tools.idea.gradle.project.GradleSyncListener;
import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.idea.structure.services.DeveloperServiceBuildSystemOperations;
import com.android.tools.idea.structure.services.DeveloperServiceMetadata;
import com.android.tools.idea.templates.RepositoryUrlManager;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;

public class GradleOperations
implements DeveloperServiceBuildSystemOperations {
    @Override
    public boolean canHandle(Project project) {
        return Projects.isBuildWithGradle(project);
    }

    @Override
    public boolean containsAllDependencies(Module module, DeveloperServiceMetadata metadata) {
        ArrayList moduleDependencyNames = Lists.newArrayList();
        GradleBuildFile gradleBuildFile = GradleBuildFile.get(module);
        if (gradleBuildFile != null) {
            for (BuildFileStatement dependency : gradleBuildFile.getDependencies()) {
                Object data;
                if (!(dependency instanceof Dependency) || !((data = ((Dependency)dependency).data) instanceof String)) continue;
                String dependencyString = (String)data;
                ArrayList dependencyParts = Lists.newArrayList((Iterable)Splitter.on((char)':').split((CharSequence)dependencyString));
                if (dependencyParts.size() != 3) continue;
                moduleDependencyNames.add(dependencyParts.get(1));
            }
        }
        boolean allDependenciesFound = true;
        for (String serviceDependency : metadata.getDependencies()) {
            boolean thisDependencyFound = false;
            for (String moduleDependencyName : moduleDependencyNames) {
                if (!serviceDependency.contains(moduleDependencyName)) continue;
                thisDependencyFound = true;
                break;
            }
            if (thisDependencyFound) continue;
            allDependenciesFound = false;
            break;
        }
        return allDependenciesFound;
    }

    @Override
    public boolean isServiceInstalled(Module module, DeveloperServiceMetadata metadata) {
        GradleBuildFile gradleFile = GradleBuildFile.get(module);
        if (gradleFile != null) {
            List<BuildFileStatement> dependencies = gradleFile.getDependencies();
            for (BuildFileStatement statement : dependencies) {
                if (!(statement instanceof Dependency)) continue;
                Dependency dependency = (Dependency)statement;
                for (String dependencyValue : metadata.getDependencies()) {
                    if (!dependency.getValueAsString().equals(dependencyValue)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public void removeDependencies(Module module, DeveloperServiceMetadata metadata) {
        final GradleBuildFile gradleFile = GradleBuildFile.get(module);
        if (gradleFile != null) {
            boolean dependenciesChanged = false;
            final List<BuildFileStatement> dependencies = gradleFile.getDependencies();
            Iterator<BuildFileStatement> iterator = dependencies.iterator();
            block0: while (iterator.hasNext()) {
                BuildFileStatement statement = iterator.next();
                if (!(statement instanceof Dependency)) continue;
                Dependency dependency = (Dependency)statement;
                for (String dependencyValue : metadata.getDependencies()) {
                    if (!dependency.getValueAsString().equals(dependencyValue)) continue;
                    iterator.remove();
                    dependenciesChanged = true;
                    continue block0;
                }
            }
            Project project = module.getProject();
            if (dependenciesChanged) {
                new WriteCommandAction.Simple(project, "Uninstall " + metadata.getName(), new PsiFile[0]){

                    public void run() {
                        gradleFile.setValue(BuildFileKey.DEPENDENCIES, dependencies);
                    }
                }.execute();
            }
            GradleProjectImporter.getInstance().requestProjectSync(project, null);
        }
    }

    @Override
    public void initializeServices(Module module, final Runnable initializationTask) {
        AndroidFacet facet = AndroidFacet.getInstance(module);
        assert (facet != null);
        facet.addListener(new GradleSyncListener.Adapter(){

            @Override
            public void syncSucceeded(Project project) {
                initializationTask.run();
            }
        });
    }

    @Override
    public String getBuildSystemId() {
        return "Gradle";
    }

    @Override
    public String getHighestVersion(String groupId, String artifactId) {
        GradleCoordinate gradleCoordinate = new GradleCoordinate(groupId, artifactId, new GradleCoordinate.RevisionComponent[]{GradleCoordinate.PLUS_REV});
        return RepositoryUrlManager.get().resolveDynamicCoordinateVersion(gradleCoordinate, null);
    }
}

